/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound;

import eu.ha3.presencefootsteps.PresenceFootsteps;

public interface Options {
    public static final Options EMPTY = new Options(){

        @Override
        public boolean containsKey(String option) {
            return false;
        }

        @Override
        public float get(String option) {
            return 0.0f;
        }
    };
    public static final Options WET_VOLUME_OPTIONS = Options.ofGetter("volume_percentage", () -> PresenceFootsteps.getInstance().getConfig().wetSoundsVolume.getPercentage());
    public static final Options FOLIAGE_VOLUME_OPTIONS = Options.ofGetter("volume_percentage", () -> PresenceFootsteps.getInstance().getConfig().foliageSoundsVolume.getPercentage());

    public static Options singular(String key, float value) {
        return Options.ofGetter(key, () -> value);
    }

    public static Options ofGetter(final String key, final FloatSupplier value) {
        return new Options(){

            @Override
            public boolean containsKey(String option) {
                return key.equals(option);
            }

            @Override
            public float get(String option) {
                return this.containsKey(option) ? value.get() : 0.0f;
            }
        };
    }

    public boolean containsKey(String var1);

    public float get(String var1);

    default public float getOrDefault(String option, float defaultValue) {
        return this.containsKey(option) ? this.get(option) : defaultValue;
    }

    default public Options and(final Options other) {
        final Options self = this;
        if (self == EMPTY) {
            return other;
        }
        return new Options(){

            @Override
            public boolean containsKey(String o) {
                return other.containsKey(o) || self.containsKey(o);
            }

            @Override
            public float get(String o) {
                return other.containsKey(o) ? other.get(o) : self.get(o);
            }
        };
    }

    public static interface FloatSupplier {
        public float get();
    }
}

