/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.api.util;

import com.github.thedeathlycow.thermoo.api.util.TemperatureRecord;
import com.mojang.serialization.Codec;
import java.util.function.DoubleUnaryOperator;
import net.minecraft.class_3542;

public enum TemperatureUnit implements class_3542
{
    CELSIUS("C", "celsius", celsiusValue -> celsiusValue, celsiusValue -> celsiusValue, 1),
    KELVIN("K", "kelvin", kelvinValue -> kelvinValue - 273.15, celsiusValue -> celsiusValue + 273.15, 1),
    FAHRENHEIT("F", "fahrenheit", fahrenheitValue -> (fahrenheitValue - 32.0) * 5.0 / 9.0, celsiusValue -> 1.8 * celsiusValue + 32.0, 3),
    RANKINE("R", "rankine", rankineValue -> FAHRENHEIT.toCelsius(rankineValue - 459.67), celsiusValue -> FAHRENHEIT.fromCelsius(celsiusValue) + 459.67, 3);

    public static final Codec<TemperatureUnit> CODEC;
    private final String unitSymbol;
    private final String name;
    private final DoubleUnaryOperator toCelsius;
    private final DoubleUnaryOperator fromCelsius;
    private final int absoluteUnitIndex;

    private TemperatureUnit(String unitSymbol, String name, DoubleUnaryOperator toCelsius, DoubleUnaryOperator fromCelsius, int absoluteUnitIndex) {
        this.unitSymbol = unitSymbol;
        this.name = name;
        this.toCelsius = toCelsius;
        this.fromCelsius = fromCelsius;
        this.absoluteUnitIndex = absoluteUnitIndex;
    }

    public TemperatureUnit getAbsoluteUnit() {
        return TemperatureUnit.values()[this.absoluteUnitIndex];
    }

    public double getAbsoluteZero() {
        return this.convertTemperature(0.0, this.getAbsoluteUnit());
    }

    public String getUnitSymbol() {
        return this.unitSymbol;
    }

    public double toCelsius(double value) {
        return this.toCelsius.applyAsDouble(value);
    }

    public double fromCelsius(double celsiusValue) {
        return this.fromCelsius.applyAsDouble(celsiusValue);
    }

    public double convertTemperature(double inputValue, TemperatureUnit inputUnit) {
        if (this == inputUnit) {
            return inputValue;
        }
        double inputCelsius = inputUnit.toCelsius(inputValue);
        return this.fromCelsius(inputCelsius);
    }

    public double convertTemperature(TemperatureRecord temperatureRecord) {
        return this.convertTemperature(temperatureRecord.value(), temperatureRecord.unit());
    }

    public String method_15434() {
        return this.name;
    }

    static {
        CODEC = class_3542.method_28140(TemperatureUnit::values);
    }
}

