/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.fabric;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.caffeinemc.mods.lithium.common.config.Option;
import net.caffeinemc.mods.lithium.common.services.PlatformMixinOverrides;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;

public class FabricMixinOverrides
implements PlatformMixinOverrides {
    protected static final String JSON_KEY_LITHIUM_OPTIONS = "lithium:options";

    @Override
    public void applyLithiumCompat(Map<String, Option> options) {
        if (FabricLoader.getInstance().isModLoaded("worldedit")) {
            options.get("mixin.compat.worldedit").addModOverride(true, "lithium");
        }
    }

    @Override
    public List<PlatformMixinOverrides.MixinOverride> applyModOverrides() {
        ArrayList<PlatformMixinOverrides.MixinOverride> list = new ArrayList<PlatformMixinOverrides.MixinOverride>();
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            ModMetadata meta = container.getMetadata();
            if (!meta.containsCustomValue(JSON_KEY_LITHIUM_OPTIONS)) continue;
            CustomValue overrides = meta.getCustomValue(JSON_KEY_LITHIUM_OPTIONS);
            if (overrides.getType() != CustomValue.CvType.OBJECT) {
                System.out.printf("[Lithium] Mod '%s' contains invalid Lithium option overrides, ignoring", meta.getId());
                continue;
            }
            for (Map.Entry entry : overrides.getAsObject()) {
                if (((CustomValue)entry.getValue()).getType() != CustomValue.CvType.BOOLEAN) {
                    System.out.printf("[Lithium] Mod '%s' attempted to override option '%s' with an invalid value, ignoring", meta.getId(), entry.getKey());
                    continue;
                }
                list.add(new PlatformMixinOverrides.MixinOverride(meta.getId(), (String)entry.getKey(), ((CustomValue)entry.getValue()).getAsBoolean()));
            }
        }
        return list;
    }
}

