/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful.survival;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.config.FrostifulConfig;
import com.github.thedeathlycow.frostiful.config.group.EnvironmentConfigGroup;
import com.github.thedeathlycow.frostiful.item.cloak.AbstractFrostologyCloakItem;
import com.github.thedeathlycow.frostiful.registry.FGameRules;
import com.github.thedeathlycow.frostiful.registry.FItems;
import com.github.thedeathlycow.thermoo.api.environment.component.EnvironmentComponentTypes;
import com.github.thedeathlycow.thermoo.api.environment.component.TemperatureRecordComponent;
import com.github.thedeathlycow.thermoo.api.environment.event.ServerPlayerEnvironmentTickEvents;
import com.github.thedeathlycow.thermoo.api.temperature.event.EnvironmentTickContext;
import com.github.thedeathlycow.thermoo.api.util.TemperatureRecord;
import com.github.thedeathlycow.thermoo.api.util.TemperatureUnit;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public final class ServerPlayerEnvironmentTickListeners {
    public static void initialize() {
        ServerPlayerEnvironmentTickEvents.GET_TEMPERATURE_CHANGE.register(ServerPlayerEnvironmentTickListeners::getTemperatureChange);
        ServerPlayerEnvironmentTickEvents.ALLOW_TEMPERATURE_CHANGE.register(ServerPlayerEnvironmentTickListeners::allowTemperatureChange);
    }

    private static int getTemperatureChange(EnvironmentTickContext<class_3222> context) {
        EnvironmentConfigGroup config;
        if (((class_3222)context.affected()).method_7325()) {
            return 0;
        }
        TemperatureRecord temperature = (TemperatureRecord)context.components().method_57830(EnvironmentComponentTypes.TEMPERATURE, (Object)TemperatureRecordComponent.DEFAULT);
        int total = ServerPlayerEnvironmentTickListeners.envTemperatureToTemperaturePoint(temperature, config = Frostiful.getConfig().environmentConfig);
        if (total < 0 && ((class_3222)context.affected()).thermoo$isWet()) {
            total = (int)((float)total * Frostiful.getConfig().environmentConfig.getEnvironmentFreezingSoakedMultiplier());
        }
        if (((class_3222)context.affected()).field_6012 % 20 == 0 && Frostiful.LOGGER.isDebugEnabled()) {
            Frostiful.LOGGER.debug("Adding {} temperature to {}", (Object)total, (Object)((class_3222)context.affected()).method_5820());
        }
        return total;
    }

    private static TriState allowTemperatureChange(EnvironmentTickContext<class_3222> context, int temperatureChange) {
        boolean doPassiveFreezing;
        if (temperatureChange > 0) {
            return TriState.DEFAULT;
        }
        FrostifulConfig config = Frostiful.getConfig();
        class_3222 player = (class_3222)context.affected();
        int tickInterval = config.freezingConfig.getPassiveFreezingTickInterval();
        if (tickInterval > 1 && player.field_6012 % tickInterval != 0) {
            return TriState.FALSE;
        }
        if (player.thermoo$getTemperatureScale() < -config.freezingConfig.getMaxPassiveFreezingPercent()) {
            return TriState.FALSE;
        }
        boolean bl = doPassiveFreezing = config.freezingConfig.doPassiveFreezing() && player.method_37908().method_8450().method_8355(FGameRules.DO_PASSIVE_FREEZING);
        if (doPassiveFreezing) {
            return TriState.TRUE;
        }
        return TriState.of((boolean)AbstractFrostologyCloakItem.isWearing((class_1657)player, stack -> stack.method_31574(FItems.FROSTOLOGY_CLOAK)));
    }

    public static int envTemperatureToTemperaturePoint(TemperatureRecord temperature) {
        return ServerPlayerEnvironmentTickListeners.envTemperatureToTemperaturePoint(temperature, new EnvironmentConfigGroup());
    }

    public static int envTemperatureToTemperaturePoint(TemperatureRecord temperature, EnvironmentConfigGroup configGroup) {
        double temperatureC = temperature.valueInUnit(TemperatureUnit.CELSIUS);
        double thresholdC = configGroup.getMaxTemperatureForColdC();
        double degreesPerTemperatureDecrease = configGroup.getDegreesCPerTemperatureDecrease();
        if (temperatureC > thresholdC) {
            return 0;
        }
        double base = (temperatureC - thresholdC - degreesPerTemperatureDecrease) / degreesPerTemperatureDecrease;
        return class_3532.method_15384((double)(configGroup.getEnvironmentTemperatureMultiplier() * base));
    }

    private ServerPlayerEnvironmentTickListeners() {
    }
}

