/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful.survival;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.block.SunLichenBlock;
import com.github.thedeathlycow.frostiful.config.FrostifulConfig;
import com.github.thedeathlycow.frostiful.entity.component.SnowAccumulationComponent;
import com.github.thedeathlycow.frostiful.registry.tag.FBlockTags;
import com.github.thedeathlycow.frostiful.registry.tag.FEnchantmentTags;
import com.github.thedeathlycow.thermoo.api.temperature.event.EnvironmentTickContext;
import com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntityTemperatureTickEvents;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public final class PassiveTemperatureEffects {
    public static void initialize() {
        LivingEntityTemperatureTickEvents.GET_PASSIVE_TEMPERATURE_CHANGE.register(PassiveTemperatureEffects::getPassiveChange);
    }

    private static int getPassiveChange(EnvironmentTickContext<? extends class_1309> context) {
        class_1309 entity = (class_1309)context.affected();
        if (entity.method_7325() || entity.thermoo$getTemperature() > 0) {
            return 0;
        }
        int total = 0;
        FrostifulConfig config = Frostiful.getConfig();
        total += PassiveTemperatureEffects.getHotFloorTemperatureChange(context, config);
        return total += PassiveTemperatureEffects.getAndUpdateBlockLightTemperatureChange(context);
    }

    private static int getHotFloorTemperatureChange(EnvironmentTickContext<? extends class_1309> context, FrostifulConfig config) {
        class_1799 footStack;
        class_1309 entity = (class_1309)context.affected();
        class_2680 steppingState = entity.method_25936();
        if (steppingState.method_26164(FBlockTags.HOT_FLOOR) && !class_1890.method_60138((class_1799)(footStack = entity.method_6118(class_1304.field_6166)), FEnchantmentTags.IS_FROSTY)) {
            SunLichenBlock.createFireParticles((class_1937)context.world(), entity.method_24515());
            return config.freezingConfig.getHeatFromHotFloor();
        }
        return 0;
    }

    private static int getAndUpdateBlockLightTemperatureChange(EnvironmentTickContext<? extends class_1309> context) {
        int warmthFromLight = PassiveTemperatureEffects.getBlockLightTemperatureChange((class_1937)context.world(), context.pos());
        if (warmthFromLight > 0) {
            SnowAccumulationComponent.get((class_1309)context.affected()).meltSnowAccumulation();
        }
        return warmthFromLight;
    }

    public static int getBlockLightTemperatureChange(class_1937 world, class_2338 pos) {
        FrostifulConfig config = Frostiful.getConfig();
        int lightLevel = world.method_8314(class_1944.field_9282, pos);
        int minLightLevel = config.environmentConfig.getMinLightForWarmth();
        int warmth = 0;
        if (lightLevel >= minLightLevel) {
            warmth = config.environmentConfig.getWarmthPerLightLevel() * (lightLevel - minLightLevel);
        }
        return warmth;
    }

    private PassiveTemperatureEffects() {
    }
}

