/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful.survival;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.config.FrostifulConfig;
import com.github.thedeathlycow.frostiful.registry.FEntityTypes;
import com.github.thedeathlycow.frostiful.registry.FItems;
import com.github.thedeathlycow.frostiful.survival.SurvivalUtils;
import com.github.thedeathlycow.thermoo.api.ThermooTags;
import com.github.thedeathlycow.thermoo.api.temperature.event.EnvironmentTickContext;
import com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntityTemperatureTickEvents;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;

public final class ActiveTemperatureEffects {
    public static void initialize() {
        LivingEntityTemperatureTickEvents.GET_ACTIVE_TEMPERATURE_CHANGE.register(ActiveTemperatureEffects::getActiveChange);
    }

    private static int getActiveChange(EnvironmentTickContext<? extends class_1309> context) {
        class_1309 entity = (class_1309)context.affected();
        if (entity.method_7325() || entity.thermoo$getTemperature() > 0) {
            return 0;
        }
        int total = 0;
        FrostifulConfig config = Frostiful.getConfig();
        total += ActiveTemperatureEffects.getOnFireTemperatureChange(entity, config);
        total += ActiveTemperatureEffects.getPowderSnowTemperatureChange(entity, config);
        total += ActiveTemperatureEffects.getConduitPowerTemperatureChange(entity, config);
        return total += ActiveTemperatureEffects.getShiveringTemperatureChange(entity, config);
    }

    private static int getOnFireTemperatureChange(class_1309 entity, FrostifulConfig config) {
        if (entity.method_5809()) {
            int onFireRate = config.environmentConfig.getOnFireWarmRate();
            if (entity.method_5864() == FEntityTypes.FROSTOLOGER) {
                onFireRate /= 2;
            }
            return onFireRate;
        }
        return 0;
    }

    private static int getPowderSnowTemperatureChange(class_1309 entity, FrostifulConfig config) {
        if (entity.field_28628) {
            return -config.environmentConfig.getPowderSnowFreezeRate();
        }
        return 0;
    }

    private static int getConduitPowerTemperatureChange(class_1309 entity, FrostifulConfig config) {
        boolean applyConduitPowerWarmth;
        boolean bl = applyConduitPowerWarmth = entity.method_5869() && entity.method_6059(class_1294.field_5927);
        if (applyConduitPowerWarmth) {
            return config.freezingConfig.getConduitWarmthPerTick();
        }
        return 0;
    }

    private static int getShiveringTemperatureChange(class_1309 entity, FrostifulConfig config) {
        boolean benefitsFromCold;
        if (!SurvivalUtils.isShivering(entity)) {
            return 0;
        }
        boolean bl = benefitsFromCold = entity.method_5864().method_20210(ThermooTags.BENEFITS_FROM_COLD_ENTITY_TYPE) || entity.method_6118(class_1304.field_6174).method_31574(FItems.FROSTOLOGY_CLOAK);
        if (benefitsFromCold) {
            return 0;
        }
        int shiverWarmth = config.freezingConfig.getShiverWarmth();
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (player.method_7344().method_7586() <= config.freezingConfig.getStopShiverWarmingBelowFoodLevel()) {
                return 0;
            }
            player.method_7322(0.04f * (float)shiverWarmth);
        }
        return shiverWarmth;
    }

    private ActiveTemperatureEffects() {
    }
}

