/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful.config.group;

import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;

@Config(name="frostiful.environment_config")
public class EnvironmentConfigGroup
implements ConfigData {
    @ConfigEntry.Gui.Tooltip
    double maxTemperatureForColdC = 10.0;
    @ConfigEntry.Gui.Tooltip
    double degreesCPerTemperatureDecrease = 10.0;
    double environmentTemperatureMultiplier = 1.0;
    boolean applyEnvironmentPenaltyWhenWet = true;
    int rainWetnessIncrease = 1;
    int touchingWaterWetnessIncrease = 5;
    int onFireDryDate = 50;
    int onFireWarmRate = 50;
    int powderSnowFreezeRate = 30;
    int warmthPerLightLevel = 2;
    int minLightForWarmth = 5;
    int maxSnowAccumulationTicks = 100;
    float environmentFreezingSoakedMultiplier = 2.0f;

    public double getMaxTemperatureForColdC() {
        return this.maxTemperatureForColdC;
    }

    public double getDegreesCPerTemperatureDecrease() {
        return this.degreesCPerTemperatureDecrease;
    }

    public double getEnvironmentTemperatureMultiplier() {
        return this.environmentTemperatureMultiplier;
    }

    public boolean applyEnvironmentPenaltyWhenWet() {
        return this.applyEnvironmentPenaltyWhenWet;
    }

    public int getRainWetnessIncrease() {
        return this.rainWetnessIncrease;
    }

    public int getTouchingWaterWetnessIncrease() {
        return this.touchingWaterWetnessIncrease;
    }

    public int getOnFireDryDate() {
        return this.onFireDryDate;
    }

    public int getOnFireWarmRate() {
        return this.onFireWarmRate;
    }

    public int getPowderSnowFreezeRate() {
        return this.powderSnowFreezeRate;
    }

    public int getWarmthPerLightLevel() {
        return this.warmthPerLightLevel;
    }

    public int getMinLightForWarmth() {
        return this.minLightForWarmth;
    }

    public int getMaxSnowAccumulationTicks() {
        return this.maxSnowAccumulationTicks;
    }

    public float getEnvironmentFreezingSoakedMultiplier() {
        return this.environmentFreezingSoakedMultiplier;
    }

    public void validatePostLoad() throws ConfigData.ValidationException {
        super.validatePostLoad();
        this.maxSnowAccumulationTicks = Math.max(0, this.maxSnowAccumulationTicks);
        if (this.maxTemperatureForColdC > 15.0) {
            this.maxTemperatureForColdC = 15.0;
        }
        if (this.degreesCPerTemperatureDecrease <= 0.0) {
            throw new ConfigData.ValidationException("Degrees C Per Temperature Decrease must be positive!");
        }
    }
}

