/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful.compat;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.registry.FStatusEffects;
import com.github.thedeathlycow.frostiful.registry.tag.FItemTags;
import com.github.thedeathlycow.frostiful.util.TextStyles;
import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class FoodIntegration {
    private static final Supplier<class_2561> TOOLTIP = Suppliers.memoize(() -> class_2561.method_43471((String)"item.frostiful.warming.tooltip").method_10862(TextStyles.WARMING_TOOLTIP));

    public static void onConsumeFood(class_1799 stack, class_1309 user) {
        if (FoodIntegration.isWarmingFood(stack)) {
            FoodIntegration.applyWarmthFromFood(user);
        }
    }

    public static void appendWarmthTooltip(class_1799 stack, class_1792.class_9635 context, class_1836 tooltipType, List<class_2561> tooltip) {
        if (FoodIntegration.isWarmingFood(stack)) {
            if (tooltipType.method_8035()) {
                FoodIntegration.addTooltipBeforeAdvanced(stack, tooltip);
            } else {
                tooltip.add(TOOLTIP.get());
            }
        }
    }

    private static boolean isWarmingFood(class_1799 stack) {
        return stack.method_31573(FItemTags.WARM_FOODS);
    }

    private static void applyWarmthFromFood(class_1309 user) {
        int duration = Frostiful.getConfig().freezingConfig.getWarmFoodWarmthTime();
        user.method_6092(new class_1293(FStatusEffects.WARMTH, duration));
    }

    private static void addTooltipBeforeAdvanced(class_1799 stack, List<class_2561> tooltip) {
        class_2960 identifier = class_7923.field_41178.method_10221((Object)stack.method_7909());
        class_5250 idAsText = class_2561.method_43470((String)identifier.toString());
        for (int i = tooltip.size() - 1; i >= 0; --i) {
            if (!tooltip.get(i).method_44745((class_2561)idAsText)) continue;
            tooltip.add(i, TOOLTIP.get());
            return;
        }
    }

    private FoodIntegration() {
    }
}

