/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.pickup;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterUpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.FilterHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.pickup.AutoPickupFilterSettings;
import com.tiviacz.travelersbackpack.inventory.upgrades.pickup.AutoPickupWidget;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2371;

public class AutoPickupUpgrade
extends FilterUpgradeBase<AutoPickupUpgrade, AutoPickupFilterSettings>
implements IEnable {
    public AutoPickupUpgrade(UpgradeManager manager, int dataHolderSlot, class_2371<class_1799> filter, List<String> filterTags) {
        super(manager, dataHolderSlot, new Point(66, 49), TravelersBackpackConfig.getConfig().backpackUpgrades.pickupUpgradeSettings.filterSlotCount, TravelersBackpackConfig.getConfig().backpackUpgrades.pickupUpgradeSettings.slotsInRow, filter, filterTags);
    }

    public boolean canPickup(class_1799 stack) {
        return ((AutoPickupFilterSettings)this.getFilterSettings()).matchesFilter(null, stack) && this.isEnabled(this);
    }

    @Override
    public AutoPickupFilterSettings createFilterSettings(UpgradeManager manager, class_2371<class_1799> filter, List<String> filterTags) {
        return new AutoPickupFilterSettings(manager.getWrapper().getStorage(), filter.stream().limit(this.getFilterSlotCount()).filter(stack -> !stack.method_7960()).toList(), this.getFilter(), filterTags);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public WidgetBase<BackpackScreen> createWidget(BackpackScreen screen, int x, int y) {
        return new AutoPickupWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    @Override
    protected FilterHandler createFilter(class_2371<class_1799> stacks, final int size) {
        return new FilterHandler(stacks, size){

            @Override
            protected void onContentsChanged(int slot) {
                AutoPickupUpgrade.this.updateDataHolderUnchecked(ModDataComponents.BACKPACK_CONTAINER, InventoryHelper.itemsToList(size, AutoPickupUpgrade.this.filter));
                ((AutoPickupFilterSettings)AutoPickupUpgrade.this.getFilterSettings()).updateFilter((List<class_1799>)((BackpackContainerContents)AutoPickupUpgrade.this.getDataHolderStack().method_57824(ModDataComponents.BACKPACK_CONTAINER)).getItems());
                ((AutoPickupFilterSettings)AutoPickupUpgrade.this.getFilterSettings()).updateFilterTags((List)AutoPickupUpgrade.this.getDataHolderStack().method_57824(ModDataComponents.FILTER_TAGS));
                AutoPickupUpgrade.this.changeListeners.forEach(Runnable::run);
            }
        };
    }
}

