/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens;

import com.tiviacz.travelersbackpack.client.screens.widgets.InventoryScroll;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.AbstractBackpackMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.DisabledSlot;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_364;
import net.minecraft.class_465;

public abstract class AbstractBackpackScreen<T extends AbstractBackpackMenu>
extends class_465<T> {
    public static final class_2960 BACKGROUND_11 = class_2960.method_60655((String)"travelersbackpack", (String)"textures/gui/background_11.png");
    public static final class_2960 BACKGROUND_9 = class_2960.method_60655((String)"travelersbackpack", (String)"textures/gui/background_9.png");
    public static final class_2960 SLOTS = class_2960.method_60655((String)"travelersbackpack", (String)"textures/gui/slots.png");
    public static final class_2960 TANKS = class_2960.method_60655((String)"travelersbackpack", (String)"textures/gui/tanks.png");
    public static final class_2960 ICONS = class_2960.method_60655((String)"travelersbackpack", (String)"textures/gui/icons.png");
    public static final class_2960 TABS = class_2960.method_60655((String)"travelersbackpack", (String)"textures/gui/tabs.png");
    public static final int TOP_BAR_OFFSET = 17;
    public int slotCount;
    public boolean wider = false;
    protected final BackpackWrapper wrapper;
    public InventoryScroll scroll = null;
    public int slotYPos;
    public boolean isScrollable = false;
    public int scrollAmount = 0;
    public static final int HEIGHT_WITHOUT_STORAGE = 114;
    public int slotsHeight;
    public int visibleSlots;
    public int visibleRows;

    protected AbstractBackpackScreen(T pMenu, class_1661 pPlayerInventory, class_2561 pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
        this.wrapper = ((AbstractBackpackMenu)((Object)pMenu)).getWrapper();
        this.field_25268 = 6;
    }

    public BackpackWrapper getWrapper() {
        return this.wrapper;
    }

    public class_1657 getScreenPlayer() {
        return ((AbstractBackpackMenu)this.method_17577()).player;
    }

    public class_327 getFont() {
        return this.field_22793;
    }

    public void updateDimensions() {
        int guiScaledHeight = class_310.method_1551().method_22683().method_4502();
        if (guiScaledHeight < this.field_2779) {
            int displayableNumberOfRows = Math.min((guiScaledHeight - 114) / 18, this.getRows());
            int newImageHeight = 114 + this.calculateSlotHeight(displayableNumberOfRows);
            this.slotsHeight = this.calculateSlotHeight(displayableNumberOfRows);
            this.visibleSlots = displayableNumberOfRows * (this.slotCount > 81 ? 11 : 9);
            this.field_2779 = newImageHeight;
            this.visibleRows = displayableNumberOfRows;
            this.isScrollable = true;
        }
    }

    public void updateBackpackSlotsPosition() {
        int allStorageSlots = ((AbstractBackpackMenu)this.field_2797).BACKPACK_INV_END;
        if (this.isScrollable) {
            int i;
            int scrollAmount = this.scrollAmount;
            int hiddenSlotsFirst = scrollAmount * this.getSlotsInRow();
            int movedSlots = this.visibleRows * this.getSlotsInRow() - hiddenSlotsFirst;
            int revealedSlots = scrollAmount * this.getSlotsInRow();
            int lastRowSlots = this.slotCount % this.getSlotsInRow();
            if (scrollAmount == this.getMaxScrollAmount() && lastRowSlots > 0) {
                revealedSlots -= this.getSlotsInRow();
                revealedSlots += lastRowSlots;
            }
            for (int i2 = 0; i2 < hiddenSlotsFirst; ++i2) {
                ((class_1735)((AbstractBackpackMenu)this.field_2797).field_7761.get((int)i2)).field_7872 = -1000;
            }
            int countSlots = 0;
            for (int i3 = hiddenSlotsFirst; i3 < hiddenSlotsFirst + movedSlots; ++i3) {
                ((class_1735)((AbstractBackpackMenu)this.field_2797).field_7761.get((int)i3)).field_7872 = this.slotYPos + (int)Math.floor((double)countSlots / (double)this.getSlotsInRow()) * 18;
                ++countSlots;
            }
            countSlots = 0;
            int lastY = this.slotYPos + (this.visibleRows - scrollAmount) * 18;
            for (i = hiddenSlotsFirst + movedSlots; i < hiddenSlotsFirst + movedSlots + revealedSlots; ++i) {
                ((class_1735)((AbstractBackpackMenu)this.field_2797).field_7761.get((int)i)).field_7872 = lastY + (int)Math.floor((double)countSlots / (double)this.getSlotsInRow()) * 18;
                ++countSlots;
            }
            for (i = hiddenSlotsFirst + movedSlots + revealedSlots; i < allStorageSlots; ++i) {
                ((class_1735)((AbstractBackpackMenu)this.field_2797).field_7761.get((int)i)).field_7872 = -1000;
            }
        }
    }

    public void updatePlayerSlotsPosition() {
        if (this.isScrollable) {
            int i;
            int firstPlayerSlotY = 32 + this.visibleRows * 18;
            int countSlots = 0;
            for (i = ((AbstractBackpackMenu)this.field_2797).PLAYER_INV_START; i < ((AbstractBackpackMenu)this.field_2797).PLAYER_HOT_END - 9; ++i) {
                ((class_1735)((AbstractBackpackMenu)this.field_2797).field_7761.get((int)i)).field_7872 = firstPlayerSlotY + (int)Math.floor((double)countSlots / 9.0) * 18;
                ++countSlots;
            }
            for (i = ((AbstractBackpackMenu)this.field_2797).PLAYER_HOT_END - 9; i < ((AbstractBackpackMenu)this.field_2797).PLAYER_HOT_END; ++i) {
                ((class_1735)((AbstractBackpackMenu)this.field_2797).field_7761.get((int)i)).field_7872 = firstPlayerSlotY + 54 + 4;
            }
        }
    }

    public int calculateSlotHeight(int displayableRows) {
        return displayableRows * 18;
    }

    public int calculateSlotHeight(boolean wider) {
        int rowSlots = wider ? 11 : 9;
        int rows = (int)Math.ceil((double)this.slotCount / (double)rowSlots);
        return rows * 18;
    }

    public int getRows() {
        return (int)Math.ceil((double)this.slotCount / (double)this.getSlotsInRow());
    }

    public int getSlotsInRow() {
        return this.wider ? 11 : 9;
    }

    public void setScrollAmount(int scrollAmount) {
        this.scrollAmount = scrollAmount;
    }

    public int getMaxScrollAmount() {
        return (int)Math.ceil((double)this.slotCount / (double)this.getSlotsInRow()) - (int)Math.ceil((double)this.visibleSlots / (double)this.getSlotsInRow());
    }

    public void renderInventoryBackground(class_332 guiGraphics, int x, int y, class_2960 texture, int xSize, int slotsHeight) {
        int halfSlotHeight = slotsHeight / 2;
        guiGraphics.method_25302(texture, x, y, 0, 0, xSize, 17 + halfSlotHeight);
        int playerInventoryHeight = 98;
        guiGraphics.method_25302(texture, x, y + 17 + halfSlotHeight, 0, 256 - (playerInventoryHeight + halfSlotHeight), xSize, playerInventoryHeight + halfSlotHeight);
    }

    public void renderSlots(class_332 guiGraphics, int x, int y, int slotCount) {
        int fullRows;
        int lastSlotRow = this.slotCount % this.getSlotsInRow();
        int visibleRows = this.visibleRows;
        int n = fullRows = this.isScrollable ? visibleRows : slotCount / this.getSlotsInRow();
        if (this.isScrollable && this.scrollAmount == this.getMaxScrollAmount() && lastSlotRow > 0) {
            --fullRows;
        }
        guiGraphics.method_25302(SLOTS, x, y, 0, 0, this.getSlotsInRow() * 18, fullRows * 18);
        if (fullRows > 9) {
            guiGraphics.method_25302(SLOTS, x, y + 162, 0, 0, this.getSlotsInRow() * 18, (fullRows - 9) * 18);
        }
        if (lastSlotRow > 0) {
            if (this.isScrollable) {
                if (this.scrollAmount == this.getMaxScrollAmount()) {
                    guiGraphics.method_25302(SLOTS, x, y + fullRows * 18, 0, fullRows * 18, lastSlotRow * 18, 18);
                }
            } else {
                guiGraphics.method_25302(SLOTS, x, y + fullRows * 18, 0, 0, lastSlotRow * 18, 18);
            }
        }
    }

    public void renderLockedBackpackSlot(class_332 guiGraphics) {
        class_1735 class_17352;
        if (((AbstractBackpackMenu)this.field_2797).disabledSlotIndex > 0 && ((AbstractBackpackMenu)this.field_2797).disabledSlotIndex < ((AbstractBackpackMenu)this.field_2797).field_7761.size() && (class_17352 = ((AbstractBackpackMenu)this.field_2797).method_7611(((AbstractBackpackMenu)this.field_2797).disabledSlotIndex)) instanceof DisabledSlot) {
            DisabledSlot slot = (DisabledSlot)class_17352;
            int x = this.field_2776 + slot.field_7873;
            int y = this.field_2800 + slot.field_7872;
            guiGraphics.method_48196(class_1921.method_51785(), x, y, x + 16, y + 16, 0, -9934744);
        }
    }

    protected void method_2389(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        this.renderScreen(guiGraphics, x, y, mouseX, mouseY, partialTicks);
        this.drawUnsortableSlots(guiGraphics);
        this.drawMemorySlots(guiGraphics);
    }

    public abstract void renderScreen(class_332 var1, int var2, int var3, int var4, int var5, float var6);

    public abstract void drawUnsortableSlots(class_332 var1);

    public abstract void drawMemorySlots(class_332 var1);

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.scroll != null) {
            return this.scroll.method_25401(mouseX, mouseY, scrollX, scrollY);
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        for (class_364 child : this.method_25396()) {
            if (!child.method_25405(mouseX, mouseY) || !child.method_25403(mouseX, mouseY, button, dragX, dragY)) continue;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        class_364 focused = this.method_25399();
        if (focused != null && !focused.method_25405(mouseX, mouseY) && focused instanceof WidgetBase) {
            WidgetBase widgetBase = (WidgetBase)focused;
            widgetBase.method_25365(false);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void sendDataToServer() {
    }

    public void playUIClickSound() {
        ((AbstractBackpackMenu)this.field_2797).getPlayerInventory().field_7546.method_37908().method_8396(((AbstractBackpackMenu)this.field_2797).getPlayerInventory().field_7546, ((AbstractBackpackMenu)this.field_2797).getPlayerInventory().field_7546.method_24515(), (class_3414)class_3417.field_15015.comp_349(), class_3419.field_15250, 0.25f, 1.0f);
    }

    public int getGuiLeft() {
        return this.field_2776;
    }

    public int getGuiTop() {
        return this.field_2800;
    }
}

