/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.worldgen;

import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.core.worldgen.SpawnBoxBlockEntity;
import net.mehvahdjukaar.moonlight.core.worldgen.SpawnBoxPoolElement;
import net.minecraft.class_156;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_3485;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3773;
import net.minecraft.class_3781;
import net.minecraft.class_3782;
import net.minecraft.class_3784;
import net.minecraft.class_3790;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6625;
import net.minecraft.class_9822;
import org.jetbrains.annotations.Nullable;

public class SpawnBoxStructurePiece
extends class_3790 {
    private static final class_5819 RAND = class_5819.method_43053();

    public SpawnBoxStructurePiece(class_3485 structureTemplateManager, SpawnBoxPoolElement poolElement, class_2338 blockPos, int groundLevelDelta, class_2470 rotation, class_9822 liquidSettings) {
        super(structureTemplateManager, (class_3784)poolElement, blockPos, groundLevelDelta, rotation, poolElement.method_16628(structureTemplateManager, blockPos, rotation), liquidSettings);
    }

    public SpawnBoxStructurePiece(class_6625 context, class_2487 tag) {
        super(context, tag);
    }

    public class_3773 method_16653() {
        return MoonlightRegistry.SPAWN_BOX_PIECE.get();
    }

    public void method_27236(class_5281 level, class_5138 structureManager, class_2794 generator, class_5819 random, class_3341 box, class_2338 pos, boolean keepJigsaws) {
    }

    @Nullable
    private String targetName() {
        class_3784 class_37842 = this.field_16693;
        if (class_37842 instanceof SpawnBoxPoolElement) {
            SpawnBoxPoolElement sbe = (SpawnBoxPoolElement)class_37842;
            return sbe.getTargetName();
        }
        return null;
    }

    @Nullable
    public static String getNamedBoxesAt(class_3449 structureStart, class_2338 pos) {
        ArrayList<SpawnBoxStructurePiece> boxes = new ArrayList<SpawnBoxStructurePiece>();
        for (class_3443 structurePiece : structureStart.method_14963()) {
            if (!(structurePiece instanceof SpawnBoxStructurePiece)) continue;
            SpawnBoxStructurePiece sb = (SpawnBoxStructurePiece)structurePiece;
            boxes.add(sb);
        }
        if (boxes.isEmpty()) {
            return null;
        }
        class_156.method_43028(boxes, (class_5819)RAND);
        for (SpawnBoxStructurePiece box : boxes) {
            if (!box.method_14935().method_14662((class_2382)pos)) continue;
            return box.targetName();
        }
        return null;
    }

    private static List<class_3499.class_3501> findSpawnBoxesInStructure(class_3784 poolElement, class_3485 manager, class_2338 pos, class_2470 rotation) {
        class_3781 sp = null;
        if (poolElement instanceof class_3781) {
            class_3781 spp;
            sp = spp = (class_3781)poolElement;
        } else if (poolElement instanceof class_3782) {
            class_3782 lp = (class_3782)poolElement;
            Object e = lp.field_16676.getFirst();
            if (e instanceof class_3781) {
                class_3781 spp;
                sp = spp = (class_3781)e;
            }
        }
        if (sp != null) {
            class_3499 structureTemplate = sp.method_27233(manager);
            return structureTemplate.method_15165(pos, new class_3492().method_15123(rotation), (class_2248)MoonlightRegistry.SPAWN_BOX_BLOCK.get(), true);
        }
        return List.of();
    }

    public static List<SpawnBoxStructurePiece> getSpawnBoxPieces(class_3790 parentPiece, class_3485 structureTemplateManager, class_9822 liquidSettings) {
        class_3784 structurePoolElement = parentPiece.method_16644();
        class_2338 parentPiecePos = parentPiece.method_16648();
        class_2470 parentPieceRot = parentPiece.method_16888();
        List<class_3499.class_3501> list = SpawnBoxStructurePiece.findSpawnBoxesInStructure(structurePoolElement, structureTemplateManager, parentPiecePos, parentPieceRot);
        ArrayList<SpawnBoxStructurePiece> result = new ArrayList<SpawnBoxStructurePiece>();
        for (class_3499.class_3501 spawnBox : list) {
            if (spawnBox.comp_1343() == null) continue;
            class_2338 spawnBoxPos = spawnBox.comp_1341();
            class_2338 offset = SpawnBoxBlockEntity.readOffsetPos(spawnBox.comp_1343());
            class_2382 size = SpawnBoxBlockEntity.readBoxSize(spawnBox.comp_1343());
            String name = SpawnBoxBlockEntity.readBoxName(spawnBox.comp_1343());
            SpawnBoxPoolElement element = new SpawnBoxPoolElement(size, (class_2382)offset, name);
            int groundLevelDelta = structurePoolElement.method_19308();
            SpawnBoxStructurePiece newPiece = new SpawnBoxStructurePiece(structureTemplateManager, element, spawnBoxPos, groundLevelDelta, parentPieceRot, liquidSettings);
            result.add(newPiece);
        }
        return result;
    }
}

