/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_117;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_219;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_5321;
import net.minecraft.class_5338;
import net.minecraft.class_5341;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_85;
import org.jetbrains.annotations.Nullable;

public class ConfigItemPoolEntry
extends class_85 {
    public static final MapCodec<ConfigItemPoolEntry> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(o -> o.tagOrItemId)).and(ConfigItemPoolEntry.method_53290((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, ConfigItemPoolEntry::new));
    @Nullable
    private final class_1792 item;
    private final String tagOrItemId;

    ConfigItemPoolEntry(String tagOrItemId, int quality, int weight, List<class_5341> lootItemConditions, List<class_117> lootItemFunctions) {
        super(quality, weight, ConfigItemPoolEntry.disableIfInvalid(tagOrItemId, lootItemConditions), lootItemFunctions);
        this.item = ConfigItemPoolEntry.getOptional(tagOrItemId);
        this.tagOrItemId = tagOrItemId;
    }

    @Nullable
    private static class_1792 getOptional(String res) {
        if (res.startsWith("#")) {
            class_6862 key = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60654((String)res.substring(1)));
            Iterator iterator = class_7923.field_41178.method_40286(key).iterator();
            if (iterator.hasNext()) {
                class_6880 v = (class_6880)iterator.next();
                return (class_1792)v.comp_349();
            }
            return null;
        }
        return class_7923.field_41178.method_17966(class_2960.method_60654((String)res)).orElse(null);
    }

    private static List<class_5341> disableIfInvalid(String res, List<class_5341> lootItemConditions) {
        if (ConfigItemPoolEntry.getOptional(res) == null) {
            ArrayList<class_5341> newCond = new ArrayList<class_5341>();
            newCond.add(class_219.method_932((float)0.0f).build());
            newCond.addAll(lootItemConditions);
            return newCond;
        }
        return lootItemConditions;
    }

    public class_5338 method_29318() {
        return MoonlightRegistry.LAZY_ITEM.get();
    }

    public void method_433(Consumer<class_1799> stackConsumer, class_47 lootContext) {
        if (this.item != null) {
            stackConsumer.accept(new class_1799((class_1935)this.item));
        } else {
            Moonlight.LOGGER.warn("Tried to add an item from a disabled OptionalLootPoolEntry");
        }
    }

    public static class_85.class_86<?> lootTableOptionalItem(String itemRes) {
        return ConfigItemPoolEntry.method_434((i, j, lootItemConditions, lootItemFunctions) -> new ConfigItemPoolEntry(itemRes, i, j, lootItemConditions, lootItemFunctions));
    }
}

