/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import java.util.WeakHashMap;
import net.mehvahdjukaar.moonlight.api.misc.CircularList;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2709;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_7157;

public class BackCommand {
    private static final int MAX_HISTORY = 10;
    private static final WeakHashMap<class_3222, CircularList<class_4208>> HISTORY = new WeakHashMap();

    public static ArgumentBuilder<class_2168, ?> register(class_7157 context) {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)"back").requires(p -> p.method_9259(2))).executes(BackCommand::teleportBack);
    }

    public static void onTeleported(class_1297 entity, class_2338 oldPos, class_5321<class_1937> oldDim) {
        if (!(entity instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)entity;
        CircularList list = HISTORY.computeIfAbsent(player, p -> new CircularList(10));
        class_4208 previousPos = class_4208.method_19443(oldDim, (class_2338)oldPos);
        if (list.isEmpty() || !((class_4208)list.getLast()).equals((Object)previousPos)) {
            list.add(previousPos);
        }
    }

    private static int teleportBack(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_1297 entity = source.method_9228();
        if (!(entity instanceof class_3222)) {
            source.method_9213((class_2561)class_2561.method_43471((String)"commands.moonlight.back.only_players"));
            return 0;
        }
        class_3222 player = (class_3222)entity;
        CircularList<class_4208> list = HISTORY.get(player);
        if (list == null || list.isEmpty()) {
            source.method_9213((class_2561)class_2561.method_43471((String)"commands.moonlight.back.empty"));
            return 0;
        }
        class_4208 last = (class_4208)list.removeLast();
        class_3218 targetLevel = source.method_9211().method_3847(last.comp_2207());
        if (targetLevel == null) {
            source.method_9213((class_2561)class_2561.method_43471((String)"commands.moonlight.back.invalid_dimension"));
            return 0;
        }
        class_2338 pos = last.comp_2208();
        double x = (double)pos.method_10263() + 0.5;
        double y = pos.method_10264();
        double z = (double)pos.method_10260() + 0.5;
        EnumSet<class_2709> set = EnumSet.of(class_2709.field_12397, class_2709.field_12401);
        BackCommand.performTeleport(source, (class_1297)player, targetLevel, x, y, z, set);
        source.method_9226(() -> class_2561.method_43469((String)"commands.teleport.success.location.single", (Object[])new Object[]{player.method_5476(), BackCommand.formatDouble(x), BackCommand.formatDouble(y), BackCommand.formatDouble(z)}), true);
        return 1;
    }

    private static void performTeleport(class_2168 source, class_1297 entity, class_3218 level, double x, double y, double z, Set<class_2709> relativeList) throws CommandSyntaxException {
        float g;
        class_2338 blockPos = class_2338.method_49637((double)x, (double)y, (double)z);
        if (!class_1937.method_25953((class_2338)blockPos)) {
            throw new CommandSyntaxException(null, (Message)class_2561.method_43471((String)"commands.teleport.invalidPosition"));
        }
        float f = class_3532.method_15393((float)entity.method_36454());
        if (entity.method_48105(level, x, y, z, relativeList, f, g = class_3532.method_15393((float)entity.method_36455()))) {
            class_1309 livingEntity;
            if (!(entity instanceof class_1309) || !(livingEntity = (class_1309)entity).method_6128()) {
                entity.method_18799(entity.method_18798().method_18805(1.0, 0.0, 1.0));
                entity.method_24830(true);
            }
            if (entity instanceof class_1314) {
                class_1314 pathfinderMob = (class_1314)entity;
                pathfinderMob.method_5942().method_6340();
            }
        }
    }

    private static String formatDouble(double d) {
        return String.format(Locale.ROOT, "%f", d);
    }
}

