/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidColors;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicClientResourceProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcePack;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcesProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.PackGenerationStrategy;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.SimplePackProvider;
import net.mehvahdjukaar.moonlight.core.ClientConfigs;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.client.MLRenderTypes;
import net.mehvahdjukaar.moonlight.core.client.SimpleSpecialModelsLoader;
import net.mehvahdjukaar.moonlight.core.client.SpawnBoxBlockEntityRenderer;
import net.mehvahdjukaar.moonlight.core.pack.DynamicResourcesInternals;
import net.mehvahdjukaar.moonlight.core.pack.MergedDynamicClientResourcesProvider;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_5352;
import net.minecraft.class_6862;
import net.minecraft.class_9224;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@ApiStatus.Internal
public class MoonlightClient {
    private static final ThreadLocal<Boolean> MAP_MIPMAP = ThreadLocal.withInitial(() -> false);
    private static final MergedDynamicClientResourcesProvider INSTANCE = new MergedDynamicClientResourcesProvider(new class_9224("moonlight:merged_pack", (class_2561)class_2561.method_43471((String)"message.moonlight.merged_pack.title"), class_5352.field_25348, Optional.empty()));
    public static ClientConfigs.ShadeFix fixShade = ClientConfigs.ShadeFix.FALSE;
    public static final Vector3f NEW_L_0 = new Vector3f(0.2f, 0.7777778f, -0.6f).normalize();
    public static final Vector3f NEW_L_1 = new Vector3f(-0.2f, 0.7777778f, 0.6f).normalize();

    public static void initClient() {
        ClientConfigs.init();
        ClientHelper.addShaderRegistration(MoonlightClient::registerShaders);
        ClientHelper.addClientReloadListener(SoftFluidColors::new, Moonlight.res("soft_fluid"));
        ClientHelper.addBlockEntityRenderersRegistration(event -> event.register(MoonlightRegistry.SPAWN_BOX_BLOCK_ENTITY.get(), SpawnBoxBlockEntityRenderer::new));
        SimpleSpecialModelsLoader specialModels = new SimpleSpecialModelsLoader();
        ClientHelper.addClientReloadListener(() -> specialModels, Moonlight.res("special_models_loader"));
        ClientHelper.addSpecialModelRegistration(specialModelEvent -> specialModels.getSpecialModels().forEach(specialModelEvent::register));
        RegHelper.registerDynamicResourceProvider(new MLDynamicClientResources());
    }

    @Nullable
    public static SimplePackProvider mergePackSupplier(DynamicResourcesProvider provider) {
        if (!ClientConfigs.MERGE_PACKS.get().booleanValue()) {
            return provider;
        }
        INSTANCE.add(provider);
        if (INSTANCE.size() == 1) {
            return INSTANCE;
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    public static boolean maybeMergeLegacyPack(DynamicResourcePack pack) {
        if (!ClientConfigs.MERGE_PACKS.get().booleanValue()) {
            return false;
        }
        INSTANCE.addLegacy(pack);
        if (INSTANCE.size() == 1) {
            RegHelper.registerResourcePack(class_3264.field_14188, INSTANCE::createPack);
        }
        return true;
    }

    public static boolean isClientThread() {
        return class_310.method_1551().method_18854();
    }

    public static void setupClient() {
        ExtraModelData e = ExtraModelData.EMPTY;
    }

    public static void onItemTooltip(class_1799 stack, class_1792.class_9635 tooltipContext, class_1836 tooltipFlag, List<class_2561> list) {
        if (ClientConfigs.TAGS_TOOLTIP.get().isOn(tooltipFlag)) {
            List<class_6862> tags;
            class_1747 bi;
            class_2248 b;
            class_2680 state;
            List<class_6862> tags2;
            class_1792 item = stack.method_7909();
            if (item instanceof class_1747 && !(tags2 = (state = (b = (bi = (class_1747)item).method_7711()).method_9564()).method_40144().toList()).isEmpty()) {
                list.add((class_2561)class_2561.method_43471((String)"tooltip.moonlight.block_tags").method_27692(class_124.field_1060));
                tags2.forEach(k -> list.add((class_2561)class_2561.method_43470((String)("-" + String.valueOf(k.comp_327()))).method_27696(class_2583.field_24360.method_36139(0xC8FFC8))));
            }
            if (!(tags = stack.method_40133().toList()).isEmpty()) {
                list.add((class_2561)class_2561.method_43471((String)"tooltip.moonlight.item_tags").method_27692(class_124.field_1076));
                tags.forEach(k -> list.add((class_2561)class_2561.method_43470((String)("-" + String.valueOf(k.comp_327()))).method_27696(class_2583.field_24360.method_36139(0xFFC8FF))));
            }
        }
    }

    public static void registerShaders(ClientHelper.ShaderEvent event) {
        event.register(Moonlight.res("particle_translucent"), class_290.field_1585, MLRenderTypes.PARTICLE_TRANSLUCENT_SHADER::assign);
        event.register(Moonlight.res("text_alpha_color"), class_290.field_20888, MLRenderTypes.TEXT_COLOR_SHADER::assign);
    }

    public static void afterTextureReload() {
        DynamicResourcesInternals.clearAfterReload(class_3264.field_14188);
    }

    public static void setMipMap(boolean b) {
        if (ClientConfigs.MAPS_MIPMAP.get() == 0) {
            b = false;
        }
        MAP_MIPMAP.set(b);
    }

    public static boolean isMapMipMap() {
        return MAP_MIPMAP.get();
    }

    private static class MLDynamicClientResources
    extends DynamicClientResourceProvider {
        protected MLDynamicClientResources() {
            super(Moonlight.res("dynamic_resources"), PackGenerationStrategy.REGEN_ON_EVERY_RELOAD);
        }

        @Override
        protected void addDynamicTranslations(AfterLanguageLoadEvent afterLanguageLoadEvent) {
        }

        @Override
        protected Collection<String> gatherSupportedNamespaces() {
            return List.of("minecraft");
        }

        @Override
        protected void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
            fixShade = ClientConfigs.FIX_SHADE.get();
            if (fixShade != ClientConfigs.ShadeFix.FALSE) {
                executor.accept((manager, sink) -> sink.addBytes(class_2960.method_60654((String)"shaders/include/light.glsl"), "#version 150\n\n#define MINECRAFT_LIGHT_POWER   (0.6)\n#define MINECRAFT_LIGHT_POWER_FIXED   (0.5)\n#define MINECRAFT_AMBIENT_LIGHT (0.4)\n#define MINECRAFT_AMBIENT_LIGHT_FIXED (0.5)\n\nvec4 minecraft_mix_light(vec3 lightDir0, vec3 lightDir1, vec3 normal, vec4 color) {\n    lightDir0 = normalize(lightDir0);\n    lightDir1 = normalize(lightDir1);\n    float light0 = max(0.0, dot(lightDir0, normal));\n    float light1 = max(0.0, dot(lightDir1, normal));\n\n    float dotP = dot(lightDir0, lightDir1);\n    bool isFixed = dotP > 0.20 && dotP < 0.205;\n    float lightPow = isFixed ? MINECRAFT_LIGHT_POWER_FIXED : MINECRAFT_LIGHT_POWER;\n    float ambientLight = isFixed ? MINECRAFT_AMBIENT_LIGHT_FIXED : MINECRAFT_AMBIENT_LIGHT;\n\n    float lightAccum = min(1.0, (light0 + light1) * lightPow + ambientLight);\n    return vec4(color.rgb * lightAccum, color.a);\n}\n\nvec4 minecraft_sample_lightmap(sampler2D lightMap, ivec2 uv) {\n    return texture(lightMap, clamp(uv / 256.0, vec2(0.5 / 16.0), vec2(15.5 / 16.0)));\n}".getBytes(), ResType.GENERIC));
            }
        }
    }
}

