/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core;

import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigBuilder;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.api.platform.configs.ModConfigHolder;

public class CommonConfigs {
    public static final Supplier<Boolean> EXTRA_DEBUG;
    public static final Supplier<Boolean> EXTRA_CHILDREN_DEBUG;
    public static final Supplier<String> GLOBAL_DATAPACKS_DIR;
    public static final Supplier<Boolean> FASTER_CACHE_SEARCH;
    public static final ModConfigHolder CONFIG;

    public static void init() {
    }

    static {
        ConfigBuilder builder = ConfigBuilder.create("moonlight", ConfigType.COMMON_SYNCED);
        builder.push("general");
        EXTRA_DEBUG = builder.comment("ONLY for debugging purpose. Turns one some debug functionality like more logging or blocktypes_debug.txt, the file can be found in ~/.minecraft/debug/dynamic_registry_dump...").define("extra_debug", false);
        EXTRA_CHILDREN_DEBUG = builder.comment("Enable this will list each BlockTypes' Children. The List of BlockTypes' children will be also in the same file via EXTRA_DEBUG. NOTE: To enable this, EXTRA_DEBUG must be enabled, too.").define("extra_children_debug", false);
        FASTER_CACHE_SEARCH = builder.comment("Makes the dynamic assets cache use a tree structure for indexing, drastically speeds up query time but could cost some ram.").define("faster_cache_search", true);
        GLOBAL_DATAPACKS_DIR = builder.comment("Global datapack folder. A folder where you can store and load datapacks for all your worlds automatically. Set to empty string to disable").define("global_datapacks_folder", "moonlight-global-datapacks");
        builder.pop();
        CONFIG = builder.build();
        CONFIG.forceLoad();
    }
}

