/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1311;
import net.minecraft.class_5483;
import net.minecraft.class_6012;

public record SpawnBoxSettings(Map<class_1311, Map<String, class_6012<class_5483.class_1964>>> spawnOverrides) {
    public static final Codec<SpawnBoxSettings> CODEC = Entry.CODEC.listOf().flatXmap(SpawnBoxSettings::fromEntries, spawnBoxSettings -> DataResult.success(spawnBoxSettings.toEntryList()));
    public static final SpawnBoxSettings EMPTY = new SpawnBoxSettings(Map.of());

    private static DataResult<SpawnBoxSettings> fromEntries(List<Entry> entries) {
        HashMap<class_1311, Map<String, class_6012<class_5483.class_1964>>> map = new HashMap<class_1311, Map<String, class_6012<class_5483.class_1964>>>();
        for (Entry e : entries) {
            map.computeIfAbsent(e.category, k -> new HashMap());
            Map catMap = (Map)map.get(e.category);
            if (catMap.containsKey(e.name)) {
                return DataResult.error(() -> "Duplicate spawn box entry for category " + String.valueOf(e.category) + " and name " + e.name);
            }
            catMap.put(e.name, e.spawns);
        }
        return DataResult.success((Object)new SpawnBoxSettings(map));
    }

    private List<Entry> toEntryList() {
        return this.spawnOverrides.entrySet().stream().flatMap(catEntry -> ((Map)catEntry.getValue()).entrySet().stream().map(nameEntry -> new Entry((class_1311)catEntry.getKey(), (String)nameEntry.getKey(), (class_6012<class_5483.class_1964>)((class_6012)nameEntry.getValue())))).toList();
    }

    public boolean hasCategory(class_1311 category) {
        return this.spawnOverrides.containsKey(category);
    }

    public class_6012<class_5483.class_1964> get(String boxID, class_1311 category) {
        Map<String, class_6012<class_5483.class_1964>> map = this.spawnOverrides.get(category);
        if (map != null) {
            return map.get(boxID);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.spawnOverrides.isEmpty();
    }

    private record Entry(class_1311 category, String name, class_6012<class_5483.class_1964> spawns) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1311.field_24655.fieldOf("category").forGetter(Entry::category), (App)Codec.STRING.fieldOf("name").forGetter(Entry::name), (App)class_6012.method_34991((Codec)class_5483.class_1964.field_24681).fieldOf("spawns").forGetter(Entry::spawns)).apply((Applicative)instance, Entry::new));
    }
}

