/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util.math;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Locale;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.minecraft.class_2350;
import net.minecraft.class_5253;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ColorUtils {
    public static final Codec<Integer> CODEC = Codec.either((Codec)Codec.INT, (Codec)Codec.STRING.flatXmap(ColorUtils::isValidStringOrError, s -> ColorUtils.isValidStringOrError(s).map(ColorUtils::formatString))).xmap(either -> (Integer)either.map(integer -> integer, s -> Integer.parseUnsignedInt(s, 16)), integer -> Either.right((Object)("#" + String.format("%08X", integer))));
    private static final Vector3f DIFFUSE_LIGHT_0 = new Vector3f(0.2f, 1.0f, -0.7f).normalize();
    private static final Vector3f DIFFUSE_LIGHT_1 = new Vector3f(-0.2f, 1.0f, 0.7f).normalize();
    public static final float MINECRAFT_LIGHT_POWER = 0.6f;
    public static final float MINECRAFT_AMBIENT_LIGHT = 0.4f;

    private static String formatString(String s) {
        return "#" + s.toUpperCase(Locale.ROOT);
    }

    public static DataResult<String> isValidStringOrError(String s) {
        String st = s;
        if (s.startsWith("0x")) {
            st = s.substring(2);
        } else if (s.startsWith("#")) {
            st = s.substring(1);
        }
        if (st.length() > 8) {
            return DataResult.error(() -> "Invalid color format. Hex value must have up to 8 characters.");
        }
        try {
            int parsedValue = Integer.parseUnsignedInt(st, 16);
            return DataResult.success((Object)st);
        }
        catch (NumberFormatException e) {
            return DataResult.error(() -> "Invalid color format. Must be in ARGB hex format ('0xff00ff00', '#ff00ff00', 'ff00ff00') or its Integer value");
        }
    }

    public static boolean isValidString(String s) {
        return ColorUtils.isValidStringOrError(s).result().isPresent();
    }

    public static int shadeColor(Vector3f normal, int color) {
        return ColorUtils.multiply(color, ColorUtils.getShading(normal));
    }

    public static float getShading(Vector3f normal) {
        if (normal.equals((Object)class_2350.field_11036.method_23955())) {
            return 1.0f;
        }
        Vector3f lightDir0 = DIFFUSE_LIGHT_0;
        Vector3f lightDir1 = DIFFUSE_LIGHT_1;
        lightDir0.normalize();
        lightDir1.normalize();
        float light0 = Math.max(0.0f, lightDir0.dot((Vector3fc)normal));
        float light1 = Math.max(0.0f, lightDir1.dot((Vector3fc)normal));
        return Math.min(1.0f, (light0 + light1) * 0.6f + 0.4f);
    }

    public static int multiply(int color, float amount) {
        if (amount == 1.0f) {
            return color;
        }
        int j = Math.min(255, (int)((float)class_5253.class_8045.method_48345((int)color) * amount));
        int k = Math.min(255, (int)((float)class_5253.class_8045.method_48346((int)color) * amount));
        int l = Math.min(255, (int)((float)class_5253.class_8045.method_48347((int)color) * amount));
        return class_5253.class_8045.method_48344((int)0, (int)l, (int)k, (int)j);
    }

    public static int lerp(int c0, int c1, float t) {
        if (t == 0.0f) {
            return c0;
        }
        if (t == 1.0f) {
            return c1;
        }
        RGBColor col = new RGBColor(c0);
        return col.mixWith(new RGBColor(c1), t).toInt();
    }

    public static int swapFormat(int argb) {
        return argb & 0xFF00FF00 | argb >> 16 & 0xFF | argb << 16 & 0xFF0000;
    }

    public static int pack(float[] rgb) {
        return class_5253.class_5254.method_27764((int)255, (int)((int)(rgb[0] * 255.0f)), (int)((int)(rgb[1] * 255.0f)), (int)((int)(rgb[2] * 255.0f)));
    }

    public static float[] unpack(int color) {
        return new float[]{(float)class_5253.class_8045.method_48345((int)color) / 255.0f, (float)class_5253.class_8045.method_48346((int)color) / 255.0f, (float)class_5253.class_8045.method_48347((int)color) / 255.0f};
    }
}

