/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.network.fabric;

import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.fabric.NetworkHelperImplClient;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5321;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class NetworkHelperImpl {
    public static void addNetworkRegistration(Consumer<NetworkHelper.RegisterMessagesEvent> eventListener, int version) {
        eventListener.accept(new NetworkHelper.RegisterMessagesEvent(){

            @Override
            public <M extends Message> void registerServerBound(class_8710.class_9155<class_9129, M> messageType) {
                PayloadTypeRegistry.playC2S().register(messageType.comp_2243(), messageType.comp_2244());
                ServerPlayNetworking.registerGlobalReceiver((class_8710.class_9154)messageType.comp_2243(), (message, context) -> context.server().execute(() -> message.handle(new ContextWrapper(context))));
            }

            @Override
            public <M extends Message> void registerClientBound(class_8710.class_9155<class_9129, M> messageType) {
                PayloadTypeRegistry.playS2C().register(messageType.comp_2243(), messageType.comp_2244());
                if (!PlatHelper.getPhysicalSide().isClient()) {
                    return;
                }
                NetworkHelperImplClient.register(messageType);
            }

            @Override
            public <M extends Message> void registerBidirectional(class_8710.class_9155<class_9129, M> messageType) {
                this.registerServerBound(messageType);
                this.registerClientBound(messageType);
            }
        });
    }

    public static void sendToClientPlayer(class_3222 serverPlayer, class_8710 message) {
        ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)message);
    }

    public static void sendToAllClientPlayers(class_8710 message) {
        for (class_3222 p : PlatHelper.getCurrentServer().method_3760().method_14571()) {
            NetworkHelperImpl.sendToClientPlayer(p, message);
        }
    }

    public static void sendToAllClientPlayersInRange(class_3218 level, class_2338 pos, double radius, class_8710 message) {
        MinecraftServer currentServer = PlatHelper.getCurrentServer();
        if (level.field_9236 || currentServer == null) {
            throw NetworkHelperImpl.makeAssertionError();
        }
        class_3324 players = currentServer.method_3760();
        class_5321 dimension = level.method_27983();
        players.method_14605(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), radius, dimension, ServerPlayNetworking.createS2CPacket((class_8710)message));
    }

    @NotNull
    private static AssertionError makeAssertionError() {
        return new AssertionError((Object)"Cant send message to clients from client side!");
    }

    public static void sendToAllClientPlayersTrackingEntity(class_1297 target, class_8710 message) {
        class_1937 level = target.method_37908();
        if (level.field_9236) {
            throw NetworkHelperImpl.makeAssertionError();
        }
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            serverLevel.method_14178().method_18754(target, ServerPlayNetworking.createS2CPacket((class_8710)message));
        }
    }

    public static void sendToAllClientPlayersTrackingEntityAndSelf(class_1297 target, Message message) {
        class_1937 level = target.method_37908();
        if (level.field_9236) {
            throw NetworkHelperImpl.makeAssertionError();
        }
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            class_2596 p = ServerPlayNetworking.createS2CPacket((class_8710)message);
            serverLevel.method_14178().method_18754(target, p);
            if (target instanceof class_3222) {
                class_3222 player = (class_3222)target;
                NetworkHelperImpl.sendToClientPlayer(player, message);
            }
        }
    }

    public static void sendToServer(class_8710 message) {
        ClientPlayNetworking.send((class_8710)message);
    }

    public static void sendToAllClientPlayersTrackingChunk(class_3218 level, class_1923 pos, class_8710 message) {
        for (class_1657 player : level.method_14178().field_17254.method_17210(pos, false)) {
            if (!(player instanceof class_3222)) continue;
            class_3222 serverPlayer = (class_3222)player;
            NetworkHelperImpl.sendToClientPlayer(serverPlayer, message);
        }
    }

    public record ContextWrapper(ServerPlayNetworking.Context c) implements Message.Context
    {
        @Override
        public Message.NetworkDir getDirection() {
            return Message.NetworkDir.SERVER_BOUND;
        }

        @Override
        public class_1657 getPlayer() {
            return this.c.player();
        }

        @Override
        public void disconnect(class_2561 reason) {
            this.c.responseSender().disconnect(reason);
        }

        @Override
        public void reply(class_8710 message) {
            this.c.responseSender().sendPacket(message);
        }
    }
}

