/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.configs.fabric;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.ConfigEntry;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values.ConfigValue;
import net.mehvahdjukaar.moonlight.core.Moonlight;

public class ConfigSubCategory
extends ConfigEntry {
    private final List<ConfigEntry> entries = new ArrayList<ConfigEntry>();

    public ConfigSubCategory(String name) {
        super(name);
    }

    public void addEntry(ConfigEntry entry) {
        this.entries.add(entry);
    }

    public List<ConfigEntry> getEntries() {
        return this.entries;
    }

    public Collection<ConfigValue<?>> gatherAllValues() {
        ArrayList list = new ArrayList();
        for (ConfigEntry e : this.entries) {
            if (e instanceof ConfigValue) {
                ConfigValue v = (ConfigValue)e;
                list.add(v);
                continue;
            }
            if (!(e instanceof ConfigSubCategory)) continue;
            ConfigSubCategory c = (ConfigSubCategory)e;
            list.addAll(c.gatherAllValues());
        }
        return list;
    }

    @Override
    public void loadFromJson(JsonObject object) {
        if (object.has(this.name)) {
            JsonElement o = object.get(this.name);
            if (o instanceof JsonObject) {
                JsonObject jo = (JsonObject)o;
                this.entries.forEach(l -> l.loadFromJson(jo));
            }
            return;
        }
        Moonlight.LOGGER.warn("Config file had missing category {}", (Object)this.name);
    }

    @Override
    public void saveToJson(JsonObject object) {
        JsonObject category = new JsonObject();
        this.entries.forEach(l -> l.saveToJson(category));
        object.add(this.name, (JsonElement)category);
    }
}

