/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.api.misc.WorldSavedData;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public final class WorldSavedDataType<D extends WorldSavedData> {
    public static final class_9139<class_9129, WorldSavedDataType<? extends WorldSavedData>> STREAM_CODEC = class_9135.method_56365((class_5321)MoonlightRegistry.WORLD_SAVED_DATA_TYPE_REGISTRY.method_30517());
    public static final Codec<WorldSavedDataType<? extends WorldSavedData>> CODEC = MoonlightRegistry.WORLD_SAVED_DATA_TYPE_REGISTRY.method_39673();
    private final Codec<D> codec;
    @Nullable
    private final class_9139<? super class_9129, D> streamCodec;
    private final class_18.class_8645<D> factory;
    private final String name;
    private final Scope scope;
    private D clientInstance = null;

    public WorldSavedDataType(class_2960 id, Function<class_3218, D> overworldToDataConstructor, Codec<D> codec, @Nullable class_9139<? super class_9129, D> streamCodec) {
        this(id, overworldToDataConstructor, codec, streamCodec, Scope.SINGLE_OVERWORLD);
    }

    public WorldSavedDataType(class_2960 id, Function<class_3218, D> overworldToDataConstructor, Codec<D> codec, @Nullable class_9139<? super class_9129, D> streamCodec, Scope scope) {
        this.codec = codec;
        this.streamCodec = streamCodec;
        this.name = id.method_36181();
        this.scope = scope;
        this.factory = new class_18.class_8645(() -> (WorldSavedData)((Object)((Object)overworldToDataConstructor.apply(PlatHelper.getCurrentServer().method_30002()))), this::load, null);
    }

    @Nullable
    public D getData(class_1937 level) {
        if (level.field_9236 && !this.isSyncable()) {
            throw new IllegalStateException("Tried to access unsyncable world saved data on client side!");
        }
        if (level instanceof class_3218) {
            class_3218 server = (class_3218)level;
            class_3218 targetLevel = this.scope.getTargetLevel(server);
            return (D)((Object)((WorldSavedData)targetLevel.method_17983().method_17924(this.factory, this.name)));
        }
        return this.clientInstance;
    }

    public void setData(class_1937 level, D data) {
        if (level instanceof class_3218) {
            class_3218 server = (class_3218)level;
            class_3218 targetLevel = this.scope.getTargetLevel(server);
            targetLevel.method_17983().method_123(this.name, data);
        } else {
            this.clientInstance = data;
        }
        ((WorldSavedData)((Object)data)).onReassigned(level);
    }

    private D load(class_2487 tag, class_7225.class_7874 provider) {
        class_2520 t = tag.method_10580(this.getName());
        class_6903 ops = provider.method_57093((DynamicOps)class_2509.field_11560);
        DataResult dataResult = this.codec.decode((DynamicOps)ops, (Object)t);
        return (D)((Object)((WorldSavedData)((Object)((Pair)dataResult.getOrThrow()).getFirst())));
    }

    public Codec<D> getCodec() {
        return this.codec;
    }

    @Nullable
    public class_9139<? super class_9129, D> getStreamCodec() {
        return this.streamCodec;
    }

    public boolean isSyncable() {
        return this.streamCodec != null;
    }

    public String getName() {
        return this.name;
    }

    public static enum Scope {
        SINGLE_OVERWORLD,
        PER_LEVEL;


        private class_3218 getTargetLevel(class_3218 sl) {
            class_3218 targetLevel = this == PER_LEVEL ? sl : sl.method_8503().method_30002();
            return targetLevel;
        }
    }
}

