/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client.util;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class TextUtil {
    private static final class_5481 CURSOR_MARKER = class_5481.method_30747((String)"_", (class_2583)class_2583.field_24360);

    public static Pair<List<class_5481>, Float> fitLinesToBox(class_327 font, class_5348 text, float width, float height) {
        int scalingFactor;
        List splitLines;
        float maxLines;
        int fontWidth = font.method_27525(text);
        do {
            scalingFactor = class_3532.method_15375((float)class_3532.method_15355((float)((float)fontWidth * 8.0f / (width * height))));
            splitLines = font.method_1728(text, class_3532.method_15375((float)(width * (float)scalingFactor)));
            maxLines = height * (float)scalingFactor / 8.0f;
            ++fontWidth;
        } while (maxLines < (float)splitLines.size());
        return Pair.of((Object)splitLines, (Object)Float.valueOf(1.0f / (float)scalingFactor));
    }

    public static class_5348 parseText(String s, @Nullable class_7225.class_7874 provider) {
        try {
            class_5250 mutableComponent = class_2561.class_2562.method_10877((String)s, (class_7225.class_7874)provider);
            if (mutableComponent != null) {
                return mutableComponent;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return class_5348.method_29430((String)s);
    }

    @Deprecated(forRemoval=true)
    public static class_5348 parseText(String s) {
        return TextUtil.parseText(s, (class_7225.class_7874)Utils.hackyGetRegistryAccess());
    }

    @Deprecated(forRemoval=true)
    public static void renderGuiLine(RenderProperties properties, String string, class_327 font, class_332 graphics, class_4597.class_4598 buffer, int cursorPos, int selectionPos, boolean isSelected, boolean blink, int yOffset) {
        Objects.requireNonNull(font);
        TextUtil.renderGuiLine(properties, string, font, graphics, cursorPos, selectionPos, isSelected, blink, yOffset, 9);
    }

    public static void renderGuiLine(RenderProperties properties, String string, class_327 font, class_332 graphics, int cursorPos, int selectionPos, boolean isSelected, boolean blink, int yOffset, int textLineHeight) {
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        int textColor = properties.textColor;
        int twoTextLineHeight = 2 * textLineHeight;
        if (string != null) {
            int strWidth = font.method_1727(string);
            int centerStr = strWidth - strWidth / 2;
            if (font.method_1726()) {
                string = font.method_1721(string);
            }
            float centerX = (float)(-font.method_1727(string)) / 2.0f;
            graphics.method_51433(font, string, (int)centerX, yOffset, textColor, false);
            if (isSelected) {
                if (blink && cursorPos >= string.length()) {
                    graphics.method_51433(font, "_", centerStr, yOffset, textColor, false);
                }
                if (blink && cursorPos < string.length()) {
                    graphics.method_25294(centerStr, yOffset - 1, centerStr + 1, yOffset + textLineHeight, 0xFF000000 | textColor);
                }
                if (selectionPos != cursorPos) {
                    int minC = Math.min(cursorPos, selectionPos);
                    int maxC = Math.max(cursorPos, selectionPos);
                    int s = font.method_1727(string.substring(0, minC)) - strWidth / 2;
                    int t = font.method_1727(string.substring(0, maxC)) - strWidth / 2;
                    int startX = Math.min(s, t);
                    int v = Math.max(s, t);
                    graphics.method_51739(class_1921.method_51786(), startX, yOffset, v, yOffset + textLineHeight, -16776961);
                }
            }
        }
    }

    @Deprecated(forRemoval=true)
    public static void renderGuiText(RenderProperties properties, String[] guiLines, class_327 font, class_332 graphics, class_4597.class_4598 buffer, int cursorPos, int selectionPos, int currentLine, boolean blink, int lineSpacing) {
        TextUtil.renderGuiText(properties, guiLines, font, graphics, cursorPos, selectionPos, currentLine, blink, lineSpacing);
    }

    public static void renderGuiText(RenderProperties properties, String[] guiLines, class_327 font, class_332 graphics, int cursorPos, int selectionPos, int currentLine, boolean blink, int lineSpacing) {
        int nOfLines = guiLines.length;
        for (int line = 0; line < nOfLines; ++line) {
            int yOffset = line * lineSpacing - nOfLines * 5;
            TextUtil.renderGuiLine(properties, guiLines[line], font, graphics, cursorPos, selectionPos, line == currentLine, blink, yOffset, lineSpacing);
        }
    }

    public static void renderLine(class_5481 formattedCharSequences, class_327 font, float yOffset, class_4587 poseStack, class_4597 buffer, RenderProperties properties) {
        if (formattedCharSequences == null) {
            return;
        }
        float x = (float)(-font.method_30880(formattedCharSequences)) / 2.0f;
        TextUtil.renderLineInternal(formattedCharSequences, font, x, yOffset, poseStack.method_23760().method_23761(), buffer, properties);
    }

    public static void renderAllLines(class_5481[] charSequences, int ySeparation, class_327 font, class_4587 poseStack, class_4597 buffer, RenderProperties properties) {
        for (int i = 0; i < charSequences.length; ++i) {
            TextUtil.renderLine(charSequences[i], font, ySeparation * i, poseStack, buffer, properties);
        }
    }

    @Deprecated(forRemoval=true)
    private static void renderLineInternal(class_5481 formattedCharSequences, class_327 font, float xOffset, float yOffset, Matrix4f matrix4f, class_4597 buffer, RenderProperties properties) {
        if (properties.outline) {
            font.method_37296(formattedCharSequences, xOffset, yOffset, properties.textColor, properties.darkenedColor, matrix4f, buffer, properties.light);
        } else {
            font.method_22942(formattedCharSequences, xOffset, yOffset, properties.darkenedColor, false, matrix4f, buffer, class_327.class_6415.field_33993, 0, properties.light);
        }
    }

    private static int getDarkenedColor(int color, boolean glowing, float mult) {
        if (color == class_1767.field_7963.method_16357() && glowing) {
            return -988212;
        }
        return ColorUtils.multiply(color, 0.4f * (glowing ? 1.0f : mult));
    }

    private static int getDarkenedColor(int color, boolean glowing) {
        return TextUtil.getDarkenedColor(color, glowing, 1.0f);
    }

    public static RenderProperties renderProperties(class_1767 dyeColor, boolean glowing, int combinedLight, class_2583 style, Vector3f normal, BooleanSupplier isVeryNear) {
        return TextUtil.renderProperties(dyeColor, glowing, 1.0f, combinedLight, style, normal, isVeryNear);
    }

    public static RenderProperties renderProperties(class_1767 dyeColor, boolean glowing, float darkColorMult, int combinedLight, class_2583 style, Vector3f normal, BooleanSupplier isVeryNear) {
        boolean outline = glowing && (dyeColor == class_1767.field_7963 || isVeryNear.getAsBoolean());
        int textColor = dyeColor.method_16357();
        float shading = ColorUtils.getShading(normal);
        int color = glowing ? textColor : ColorUtils.multiply(textColor, shading);
        int dark = !glowing || outline ? TextUtil.getDarkenedColor(textColor, glowing, darkColorMult * shading) : color;
        return new RenderProperties(color, dark, outline, glowing ? 0xF000F0 : combinedLight, style);
    }

    public record RenderProperties(int textColor, int darkenedColor, boolean outline, int light, class_2583 style) {
    }
}

