/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.region;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.class_3300;
import team.creative.ambientsounds.condition.AmbientCondition;
import team.creative.ambientsounds.condition.AmbientSelection;
import team.creative.ambientsounds.dimension.AmbientDimension;
import team.creative.ambientsounds.engine.AmbientEngine;
import team.creative.ambientsounds.engine.AmbientEngineLoadException;
import team.creative.ambientsounds.engine.AmbientStackType;
import team.creative.ambientsounds.environment.AmbientEnvironment;
import team.creative.ambientsounds.sound.AmbientSound;
import team.creative.creativecore.common.config.api.CreativeConfig;

public class AmbientRegion
extends AmbientCondition {
    public String name;
    public AmbientStackType stack = AmbientStackType.overwrite;
    public AmbientSound[] sounds;
    @SerializedName(value="sound-collections")
    public String[] soundCollections;
    @CreativeConfig.DecimalRange(min=0.0, max=1.0)
    public transient double volumeSetting = 1.0;
    protected transient boolean active;
    public transient LinkedHashMap<String, AmbientSound> loadedSounds;
    public transient List<AmbientSound> playing = new ArrayList<AmbientSound>();
    public transient AmbientDimension dimension;

    public void load(AmbientEngine engine, Gson gson, class_3300 manager) throws AmbientEngineLoadException {
        if (this.sounds != null) {
            this.loadedSounds = new LinkedHashMap();
            for (int i = 0; i < this.sounds.length; ++i) {
                AmbientSound sound = this.sounds[i];
                this.loadedSounds.put(sound.name, sound);
            }
        }
    }

    @Override
    public String regionName() {
        return this.name;
    }

    @Override
    public void init(AmbientEngine engine) throws AmbientEngineLoadException {
        super.init(engine);
        if (this.loadedSounds != null) {
            for (AmbientSound sound : this.loadedSounds.values()) {
                sound.init(engine);
            }
        }
        if (this.soundCollections != null) {
            if (this.loadedSounds == null) {
                this.loadedSounds = new LinkedHashMap();
            }
            engine.consumeSoundCollections(this.soundCollections, x -> this.loadedSounds.put(x.name, x.copy()));
        }
    }

    @Override
    public AmbientSelection value(AmbientEnvironment env) {
        if (this.dimension != null && this.dimension != env.dimension) {
            return null;
        }
        if (this.volumeSetting == 0.0) {
            return null;
        }
        AmbientSelection selection = super.value(env);
        if (selection != null) {
            selection.mulSetting(this.volumeSetting);
        }
        return selection;
    }

    public boolean fastTick(AmbientEnvironment env) {
        if (!this.playing.isEmpty()) {
            Iterator<AmbientSound> iterator = this.playing.iterator();
            while (iterator.hasNext()) {
                AmbientSound sound = iterator.next();
                if (sound.fastTick(env)) continue;
                sound.deactivate();
                iterator.remove();
            }
        }
        return !this.playing.isEmpty();
    }

    public boolean tick(AmbientEnvironment env) {
        if (this.loadedSounds == null) {
            return false;
        }
        AmbientSelection selection = this.value(env);
        for (AmbientSound sound : this.loadedSounds.values()) {
            if (sound.tick(env, selection)) {
                if (sound.isActive()) continue;
                sound.activate();
                this.playing.add(sound);
                continue;
            }
            if (!sound.isActive()) continue;
            sound.deactivate();
            this.playing.remove(sound);
        }
        return !this.playing.isEmpty();
    }

    public boolean isActive() {
        return this.active;
    }

    public void activate() {
        this.active = true;
    }

    public void deactivate() {
        this.active = false;
        if (!this.playing.isEmpty()) {
            for (AmbientSound sound : this.playing) {
                sound.deactivate();
            }
            this.playing.clear();
        }
    }

    public String toString() {
        return this.name + ", playing: " + this.playing.size();
    }
}

