/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Stream;
import snownee.kiwi.util.NotNullByDefault;

@NotNullByDefault
public class KeyedList<K, E>
extends ArrayList<E> {
    private static final long serialVersionUID = -5150601089854895739L;
    private final ArrayList<K> keys;

    public KeyedList() {
        this.keys = Lists.newArrayList();
    }

    public KeyedList(int initialCapacity) {
        super(initialCapacity);
        this.keys = Lists.newArrayListWithCapacity((int)initialCapacity);
    }

    @Override
    public E remove(int index) {
        this.keys.remove(index);
        return super.remove(index);
    }

    public int indexOfKey(K key) {
        return this.keys.indexOf(key);
    }

    public boolean containsKey(K key) {
        return this.keys.contains(key);
    }

    private void put(int index, K key, E element) {
        if (this.containsKey(key)) {
            throw new IllegalArgumentException("Key already exists: " + String.valueOf(key));
        }
        this.keys.add(index, key);
        super.add(index, element);
    }

    public void putFirst(K key, E element) {
        this.put(0, key, element);
    }

    public void putLast(K key, E element) {
        this.put(this.keys.size(), key, element);
    }

    public void putAfter(K relativeKey, K key, E element) {
        int index = this.indexOfKey(relativeKey);
        if (index == -1) {
            throw new IllegalArgumentException("Key not found: " + String.valueOf(relativeKey));
        }
        this.put(index + 1, key, element);
    }

    public void putBefore(K relativeKey, K key, E element) {
        int index = this.indexOfKey(relativeKey);
        if (index == -1) {
            throw new IllegalArgumentException("Key not found: " + String.valueOf(relativeKey));
        }
        this.put(index, key, element);
    }

    public boolean removeKey(K key) {
        return this.remove(this.indexOfKey(key)) != null;
    }

    public boolean replace(K key, E element) {
        int index = this.indexOfKey(key);
        if (index == -1) {
            return false;
        }
        this.set(index, element);
        return true;
    }

    public Stream<K> keys() {
        return this.keys.stream();
    }

    @Override
    @Deprecated
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }
}

