/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.util;

import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2488;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_6326;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import snownee.kiwi.Mod;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.util.GameObjectLookup;
import snownee.snow.GameEvents;
import snownee.snow.SnowCommonConfig;
import snownee.snow.SnowRealMagic;
import snownee.snow.compat.diagonalfences.DiagonalFencesCompat;
import snownee.snow.compat.diagonalwalls.DiagonalWallsCompat;
import snownee.snow.compat.sereneseasons.SereneSeasonsCompat;

@Mod(value="snowrealmagic")
public class CommonProxy
implements ModInitializer {
    public static boolean fabricSeasons = Platform.isModLoaded((String)"seasons");
    public static boolean sereneSeasons = Platform.isModLoaded((String)"sereneseasons");

    public static boolean isHot(class_3610 fluidState, class_1937 level, class_2338 pos) {
        return fluidState.method_15772().method_32359().orElse(null) == class_3417.field_15202 || fluidState.method_15767(class_3486.field_15518);
    }

    public static boolean weatherTick(class_3218 level, BooleanSupplier action) {
        if (sereneSeasons) {
            return SereneSeasonsCompat.weatherTick(level, action);
        }
        return action.getAsBoolean();
    }

    public static boolean snowAccumulationNow(class_1937 level) {
        if (!level.method_8419()) {
            return false;
        }
        if (SnowCommonConfig.snowAccumulationDuringSnowfall) {
            return true;
        }
        return SnowCommonConfig.snowAccumulationDuringSnowstorm && (level.method_8546() || sereneSeasons);
    }

    public static boolean shouldMelt(class_1937 level, class_2338 pos) {
        return CommonProxy.shouldMelt(level, pos, (class_6880<class_1959>)level.method_23753(pos), 1);
    }

    public static boolean shouldMelt(class_1937 level, class_2338 pos, class_6880<class_1959> biome, int layers) {
        if (SnowCommonConfig.snowNeverMelt) {
            return false;
        }
        if (sereneSeasons) {
            return SereneSeasonsCompat.shouldMelt(level, pos, biome);
        }
        if (CommonProxy.snowAndIceMeltInWarmBiomes((class_5321<class_1937>)level.method_27983(), biome) && ((class_1959)biome.comp_349()).method_39927(pos) && CommonProxy.skyLightEnoughToMelt(level, pos, layers)) {
            return true;
        }
        if (layers <= 1) {
            if (SnowCommonConfig.snowAccumulationMaxLayers < 9) {
                return false;
            }
            if (!(level.method_8320(pos.method_10074()).method_26204() instanceof class_2488)) {
                return false;
            }
        }
        return SnowCommonConfig.snowNaturalMelt && CommonProxy.skyLightEnoughToMelt(level, pos, layers);
    }

    public static boolean snowAndIceMeltInWarmBiomes(class_5321<class_1937> dimension, class_6880<class_1959> biome) {
        if (SnowCommonConfig.snowAndIceMeltInWarmBiomes) {
            return true;
        }
        if (sereneSeasons) {
            return SereneSeasonsCompat.snowAndIceMeltInWarmBiomes(dimension, biome);
        }
        return fabricSeasons;
    }

    public static boolean skyLightEnoughToMelt(class_1937 level, class_2338 pos, int layers) {
        return level.method_8314(class_1944.field_9284, layers == 8 ? pos.method_10084() : pos) > 2;
    }

    public static boolean coldEnoughToSnow(class_4538 level, class_2338 pos, class_6880<class_1959> biome) {
        if (sereneSeasons) {
            return SereneSeasonsCompat.coldEnoughToSnow(level, pos, biome);
        }
        return ((class_1959)biome.comp_349()).method_33599(pos);
    }

    public static boolean isWinter(class_1937 level, class_2338 pos, class_6880<class_1959> biome) {
        if (sereneSeasons) {
            return SereneSeasonsCompat.isWinter(level, pos, biome);
        }
        return false;
    }

    public void onInitialize() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            if (SnowCommonConfig.debugSpawningCommand) {
                class_6326.method_36184((CommandDispatcher)dispatcher);
            }
        });
        UseBlockCallback.EVENT.register(GameEvents::onItemUse);
        PlayerBlockBreakEvents.BEFORE.register(GameEvents::onDestroyedByPlayer);
        if (sereneSeasons) {
            SnowRealMagic.LOGGER.info("SereneSeasons detected. Overriding weather behavior.");
        }
        if (Platform.isModLoaded((String)"diagonalfences")) {
            DiagonalFencesCompat.init();
        }
        if (Platform.isModLoaded((String)"diagonalwalls")) {
            DiagonalWallsCompat.init();
        }
    }

    public static List<class_2248> allSnowBlocks() {
        return GameObjectLookup.all((class_5321)class_7924.field_41254, (String)"snowrealmagic").toList();
    }
}

