/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.convert;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2356;
import net.minecraft.class_2420;
import net.minecraft.class_2473;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2510;
import net.minecraft.class_2526;
import net.minecraft.class_2544;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3830;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.util.NotNullByDefault;
import snownee.snow.CoreModule;
import snownee.snow.SnowCommonConfig;
import snownee.snow.SnowRealMagic;
import snownee.snow.convert.BlockConverter;
import snownee.snow.convert.CoveredBlockConverter;
import snownee.snow.util.KeyedList;

@NotNullByDefault
public class BlockConverters {
    public final KeyedList<class_2960, BlockConverter> converters = new KeyedList();
    public final KeyedList<class_2960, BlockConverter> airConverters = new KeyedList(1);
    private final Object2ObjectLinkedOpenHashMap<class_2680, @Nullable BlockConverter> cache = new Object2ObjectLinkedOpenHashMap();

    public void add(class_2960 id, BlockConverter converter) {
        if (converter.acceptAir()) {
            this.airConverters.putLast(id, converter);
        } else {
            this.converters.putLast(id, converter);
        }
    }

    @Nullable
    public BlockConverter of(class_2680 blockState) {
        BlockConverter converter = (BlockConverter)this.cache.computeIfAbsent((Object)blockState, this::ofInternal);
        if (this.cache.size() > 1024) {
            this.cache.removeFirst();
        }
        return converter;
    }

    @Nullable
    private BlockConverter ofInternal(class_2680 blockState) {
        for (BlockConverter converter : blockState.method_26215() ? this.airConverters : this.converters) {
            if (!converter.takeIn(blockState)) continue;
            return converter.accept(blockState) ? converter : null;
        }
        return null;
    }

    public void initSnow() {
        this.add(SnowRealMagic.id("air"), new BlockConverter(this){

            @Override
            public boolean takeIn(class_2680 blockState) {
                return true;
            }

            @Override
            public boolean acceptAir() {
                return true;
            }

            @Override
            public class_2680 convert(class_1936 level, class_2338 pos, class_2680 blockState, int layers) {
                class_2248 block = class_2246.field_10477;
                if (SnowCommonConfig.fancySnowOnUpperSlab && level.method_8320(pos.method_10074()).method_26204() instanceof class_2482) {
                    block = (class_2248)CoreModule.SNOW_BLOCK.get();
                }
                return block.method_9564();
            }
        });
        this.add(SnowRealMagic.id("double_plant"), new BlockConverter(this){

            @Override
            public boolean takeIn(class_2680 blockState) {
                return blockState.method_26204() instanceof class_2320;
            }

            @Override
            public class_2680 convert(class_1936 level, class_2338 pos, class_2680 blockState, int layers) {
                if (blockState.method_11654((class_2769)class_2320.field_10929) == class_2756.field_12607) {
                    return CoreModule.SNOWY_DOUBLE_PLANT_LOWER.defaultBlockState();
                }
                return CoreModule.SNOWY_DOUBLE_PLANT_UPPER.defaultBlockState();
            }
        });
        this.add(SnowRealMagic.id("slab"), new CoveredBlockConverter(this, class_2482.class, CoreModule.SLAB.defaultBlockState()){

            @Override
            public boolean accept(class_2680 blockState) {
                return blockState.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12681;
            }

            @Override
            public class_2680 convert(class_1936 level, class_2338 pos, class_2680 blockState, int layers) {
                return this.result;
            }
        });
        this.add(SnowRealMagic.id("stairs"), new CoveredBlockConverter(this, class_2510.class, CoreModule.STAIRS.defaultBlockState()){

            @Override
            public boolean accept(class_2680 blockState) {
                return super.accept(blockState) && blockState.method_11654((class_2769)class_2510.field_11572) == class_2760.field_12617;
            }
        });
        this.add(SnowRealMagic.id("wall"), new CoveredBlockConverter(class_2544.class, CoreModule.WALL.defaultBlockState()));
        this.add(SnowRealMagic.id("fence"), new CoveredBlockConverter(this, class_2354.class, CoreModule.FENCE.defaultBlockState()){

            @Override
            public class_2680 result(class_2680 blockState) {
                return (blockState.method_26231() == class_2498.field_11547 || blockState.method_26164(class_3481.field_17619) ? CoreModule.FENCE : CoreModule.FENCE2).defaultBlockState();
            }
        });
        this.add(SnowRealMagic.id("fence_gate"), new CoveredBlockConverter(class_2349.class, CoreModule.FENCE_GATE.defaultBlockState()));
        this.add(SnowRealMagic.id("plant"), new BlockConverter(this){

            @Override
            public boolean takeIn(class_2680 blockState) {
                return blockState.method_26164(CoreModule.PLANTS);
            }

            @Override
            public class_2680 convert(class_1936 level, class_2338 pos, class_2680 blockState, int layers) {
                return CoreModule.SNOWY_PLANT.defaultBlockState();
            }
        });
        this.add(SnowRealMagic.id("fallback"), new BlockConverter(this){

            @Override
            public boolean takeIn(class_2680 blockState) {
                class_2248 block = blockState.method_26204();
                return block instanceof class_2526 || block instanceof class_2356 || block instanceof class_2473 || block instanceof class_2420 || block instanceof class_3830 || blockState.method_26164(CoreModule.CONTAINABLES);
            }

            @Override
            public class_2680 convert(class_1936 level, class_2338 pos, class_2680 blockState, int layers) {
                return (blockState.method_26220((class_1922)level, pos).method_1110() ? CoreModule.SNOW_BLOCK : CoreModule.SNOW_EXTRA_COLLISION_BLOCK).defaultBlockState();
            }
        });
    }
}

