/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import net.minecraft.class_1540;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2488;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import snownee.snow.CoreModule;
import snownee.snow.Hooks;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.SnowVariant;
import snownee.snow.mixin.IceBlockAccess;
import snownee.snow.util.CommonProxy;

public class WorldTickHandler {
    public static boolean tick(class_3218 level, class_2338 pos) {
        class_2338.class_2339 mutable = level.method_8598(class_2902.class_2903.field_13197, pos).method_25503();
        boolean coldEnoughToSnow = CommonProxy.coldEnoughToSnow((class_4538)level, (class_2338)mutable, (class_6880<class_1959>)level.method_23753((class_2338)mutable));
        if (coldEnoughToSnow) {
            return WorldTickHandler.doSnow(level, mutable);
        }
        WorldTickHandler.doMelt(level, mutable);
        return false;
    }

    private static void doMelt(class_3218 level, class_2338.class_2339 pos) {
        class_2680 stateAbove;
        class_2680 blockState = level.method_8320((class_2338)pos.method_10098(class_2350.field_11033));
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof IceBlockAccess) {
            IceBlockAccess ice = (IceBlockAccess)class_22482;
            class_6880 biome = level.method_23753((class_2338)pos);
            if (CommonProxy.snowAndIceMeltInWarmBiomes((class_5321<class_1937>)level.method_27983(), (class_6880<class_1959>)biome) && ((class_1959)biome.comp_349()).method_39927((class_2338)pos)) {
                ice.callMelt(blockState, (class_1937)level, (class_2338)pos);
            }
            return;
        }
        if (blockState.method_26204() instanceof SnowVariant) {
            Hooks.randomTick(blockState, level, (class_2338)pos, level.field_9229, 1.0f);
        }
        if ((stateAbove = level.method_8320((class_2338)pos.method_10098(class_2350.field_11036))).method_26204() instanceof SnowVariant) {
            Hooks.randomTick(stateAbove, level, (class_2338)pos, level.field_9229, 1.0f);
        }
    }

    private static boolean doSnow(class_3218 level, class_2338.class_2339 pos) {
        int blizzard;
        if (!level.method_8419()) {
            return false;
        }
        int n = blizzard = SnowCommonConfig.snowGravity ? level.method_8450().method_8356(CoreModule.BLIZZARD_STRENGTH) : 0;
        if (blizzard > 0) {
            WorldTickHandler.doBlizzard(level, (class_2338)pos, blizzard);
            return true;
        }
        if (SnowCommonConfig.snowAccumulationMaxLayers <= 0) {
            return false;
        }
        class_2680 blockState = level.method_8320((class_2338)pos);
        if (!WorldTickHandler.snowHereIfPossible(level, pos, blockState) && !WorldTickHandler.snowHereIfPossible(level, pos, blockState = level.method_8320((class_2338)pos.method_10098(class_2350.field_11033)))) {
            return false;
        }
        for (int i = 0; i < 5 && !blockState.method_26164(class_3481.field_15469) && !blockState.method_26164(class_3481.field_15459) && ((blockState = level.method_8320((class_2338)pos.method_10098(class_2350.field_11033))).method_26215() || Hooks.canContainState(blockState)); ++i) {
            if (!Hooks.canSnowSurvive((class_4538)level, (class_2338)pos)) continue;
            pos.method_10098(class_2350.field_11036);
            if (level.method_8320((class_2338)pos).method_26204() instanceof class_2488 || level.method_8314(class_1944.field_9282, (class_2338)pos) > SnowCommonConfig.snowSpawnMaxLightLevel) break;
            Hooks.convert((class_1936)level, (class_2338)pos.method_10098(class_2350.field_11033), blockState, 1, 3, SnowCommonConfig.placeSnowOnBlockNaturally);
        }
        return true;
    }

    private static boolean snowHereIfPossible(class_3218 level, class_2338.class_2339 pos, class_2680 blockState) {
        if (level.method_8314(class_1944.field_9282, (class_2338)pos.method_10098(class_2350.field_11036)) > SnowCommonConfig.snowSpawnMaxLightLevel) {
            pos.method_10098(class_2350.field_11033);
            return false;
        }
        return Hooks.convert((class_1936)level, (class_2338)pos.method_10098(class_2350.field_11033), blockState, 1, 3, SnowCommonConfig.placeSnowOnBlockNaturally);
    }

    private static void doBlizzard(class_3218 world, class_2338 pos, int blizzard) {
        if (pos.method_10264() == world.method_31605()) {
            return;
        }
        int frequency = world.method_8450().method_8356(CoreModule.BLIZZARD_FREQUENCY);
        if ((frequency = class_3532.method_15340((int)frequency, (int)0, (int)10000)) == 0) {
            return;
        }
        int i = world.field_9229.method_43048(10000);
        if (frequency != 10000 && i >= frequency) {
            return;
        }
        if ((blizzard = class_3532.method_15340((int)blizzard, (int)1, (int)8)) > 1) {
            blizzard = world.field_9229.method_43048(blizzard) + 1;
        }
        pos = pos.method_10086(64);
        class_1540.method_40005((class_1937)world, (class_2338)pos, (class_2680)((class_2680)class_2246.field_10477.method_9564().method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(blizzard))));
    }
}

