/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util.resource;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.Kiwi;
import snownee.kiwi.shadowed.com.ezylang.evalex.Expression;
import snownee.kiwi.util.KEval;
import snownee.kiwi.util.KUtil;
import snownee.kiwi.util.resource.AlternativesFileToIdConverter;

public class OneTimeLoader {
    private static final Gson GSON = new GsonBuilder().setLenient().create();

    public static <T> Map<class_2960, T> load(class_3300 resourceManager, String directory, Codec<T> codec, Context context) {
        AlternativesFileToIdConverter fileToIdConverter = AlternativesFileToIdConverter.yamlOrJson(directory);
        HashMap results = Maps.newHashMap();
        for (Map.Entry<class_2960, class_3298> entry : fileToIdConverter.listMatchingResources(resourceManager).entrySet()) {
            DataResult<T> result;
            class_2960 key = entry.getKey();
            if (context.isNamespaceDisabled(key.method_12836()) || (result = OneTimeLoader.parseFile(key, entry.getValue(), codec, context)) == null) continue;
            if (result.error().isPresent()) {
                Kiwi.LOGGER.error("Failed to parse " + String.valueOf(key) + ": " + String.valueOf(result.error().get()));
                continue;
            }
            class_2960 id = fileToIdConverter.fileToId(key);
            results.put(id, result.result().orElseThrow());
        }
        return results;
    }

    @Nullable
    public static <T> T loadFile(class_3300 resourceManager, String directory, class_2960 id, Codec<T> codec, @Nullable Context context) {
        AlternativesFileToIdConverter fileToIdConverter = AlternativesFileToIdConverter.yamlOrJson(directory);
        class_2960 file = fileToIdConverter.idToFile(id);
        Optional resource = resourceManager.method_14486(file);
        if (resource.isEmpty()) {
            return null;
        }
        DataResult<T> result = OneTimeLoader.parseFile(file, (class_3298)resource.get(), codec, context);
        if (result == null) {
            return null;
        }
        if (result.error().isPresent()) {
            Kiwi.LOGGER.error("Failed to parse " + String.valueOf(file) + ": " + String.valueOf(result.error().get()));
            return null;
        }
        return result.result().orElseThrow();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static <T> DataResult<T> parseFile(class_2960 file, class_3298 resource, Codec<T> codec, @Nullable Context context) {
        String ext = file.method_12832().substring(file.method_12832().length() - 5);
        try (BufferedReader reader = resource.method_43039();){
            Optional condition;
            Dynamic dynamic;
            if (ext.equals(".json")) {
                value = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                dynamic = new Dynamic((DynamicOps)JsonOps.INSTANCE, value);
            } else {
                if (!ext.equals(".yaml")) {
                    DataResult value = DataResult.error(() -> "Unknown extension: " + ext);
                    return value;
                }
                value = KUtil.loadYaml(reader, Object.class);
                dynamic = new Dynamic((DynamicOps)JavaOps.INSTANCE, value);
            }
            if (context != null && (condition = dynamic.get("condition").asString().result()).isPresent()) {
                try {
                    Expression expression = context.getExpression((String)condition.get());
                    if (expression.evaluate().getBooleanValue() != Boolean.FALSE) {
                        DataResult<T> dataResult = null;
                        return dataResult;
                    }
                }
                catch (Exception e) {
                    Kiwi.LOGGER.error("Failed to parse condition in " + String.valueOf(file) + ": " + String.valueOf(e));
                }
            }
            DataResult dataResult = codec.parse(dynamic);
            return dataResult;
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to load " + String.valueOf(file) + ": " + String.valueOf(e));
        }
    }

    public static class Context {
        private Map<String, Expression> cachedExpressions;
        private Set<String> disabledNamespaces;

        public Expression getExpression(String expression) {
            if (this.cachedExpressions == null) {
                this.cachedExpressions = Maps.newHashMap();
            }
            return this.cachedExpressions.computeIfAbsent(expression, $ -> new Expression((String)$, KEval.config()));
        }

        public void addDisabledNamespace(String namespace) {
            if (this.disabledNamespaces == null) {
                this.disabledNamespaces = Sets.newHashSet();
            }
            this.disabledNamespaces.add(namespace);
        }

        public boolean isNamespaceDisabled(String namespace) {
            return this.disabledNamespaces != null && this.disabledNamespaces.contains(namespace);
        }
    }
}

