/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util.codec;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4550;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8813;
import snownee.kiwi.RenderLayerEnum;
import snownee.kiwi.customization.block.loader.BlockCodecs;

public class CustomizationCodecs {
    public static final BiMap<String, class_2766> INSTRUMENTS = HashBiMap.create();
    public static final Codec<class_2766> INSTRUMENT_CODEC = CustomizationCodecs.simpleByNameCodec(INSTRUMENTS);
    public static final BiMap<String, class_3620> MAP_COLORS = HashBiMap.create();
    public static final Codec<class_3620> MAP_COLOR_CODEC = CustomizationCodecs.simpleByNameCodec(MAP_COLORS);
    public static final Codec<class_3619> PUSH_REACTION = CustomizationCodecs.simpleByNameCodec(ImmutableBiMap.of((Object)"normal", (Object)class_3619.field_15974, (Object)"destroy", (Object)class_3619.field_15971, (Object)"block", (Object)class_3619.field_15972, (Object)"ignore", (Object)class_3619.field_15975, (Object)"push_only", (Object)class_3619.field_15970));
    public static final Codec<RenderLayerEnum> RENDER_TYPE = CustomizationCodecs.simpleByNameCodec(ImmutableBiMap.of((Object)"cutout", (Object)((Object)RenderLayerEnum.CUTOUT), (Object)"cutout_mipped", (Object)((Object)RenderLayerEnum.CUTOUT_MIPPED), (Object)"translucent", (Object)((Object)RenderLayerEnum.TRANSLUCENT)));
    public static final Codec<class_4970.class_2250> OFFSET_TYPE = CustomizationCodecs.simpleByNameCodec(ImmutableBiMap.of((Object)"xz", (Object)class_4970.class_2250.field_10657, (Object)"xyz", (Object)class_4970.class_2250.field_10655));
    public static final Codec<class_4970.class_4973> STATE_PREDICATE = Codec.BOOL.flatComapMap(bl -> bl != false ? class_2246::method_26113 : class_2246::method_26122, p -> DataResult.error(() -> "Unsupported operation"));
    public static final Codec<class_8813> TREE_GROWER = Codec.withAlternative((Codec)class_8813.field_46510, (Codec)RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(BlockCodecs::notImplemented), (App)Codec.FLOAT.optionalFieldOf("secondary_chance", (Object)Float.valueOf(0.0f)).forGetter(BlockCodecs::notImplemented), (App)class_5321.method_39154((class_5321)class_7924.field_41239).optionalFieldOf("mega_tree").forGetter(BlockCodecs::notImplemented), (App)class_5321.method_39154((class_5321)class_7924.field_41239).optionalFieldOf("secondary_mega_tree").forGetter(BlockCodecs::notImplemented), (App)class_5321.method_39154((class_5321)class_7924.field_41239).optionalFieldOf("tree").forGetter(BlockCodecs::notImplemented), (App)class_5321.method_39154((class_5321)class_7924.field_41239).optionalFieldOf("secondary_tree").forGetter(BlockCodecs::notImplemented), (App)class_5321.method_39154((class_5321)class_7924.field_41239).optionalFieldOf("flowers").forGetter(BlockCodecs::notImplemented), (App)class_5321.method_39154((class_5321)class_7924.field_41239).optionalFieldOf("secondary_flowers").forGetter(BlockCodecs::notImplemented)).apply((Applicative)instance, class_8813::new)));
    public static final Codec<class_4550> BLOCK_PREDICATE = new Codec<class_4550>(){

        public <T> DataResult<Pair<class_4550, T>> decode(DynamicOps<T> ops, T input) {
            String stringValue = ops.getStringValue(input).result().orElse(null);
            if (stringValue != null) {
                if (stringValue.startsWith("#")) {
                    return DataResult.success((Object)Pair.of((Object)class_4550.class_4710.method_23880().method_29233(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60654((String)stringValue.substring(1)))).method_23882(), (Object)ops.empty()));
                }
                return DataResult.success((Object)Pair.of((Object)class_4550.class_4710.method_23880().method_27962(new class_2248[]{(class_2248)class_7923.field_41175.method_10223(class_2960.method_60654((String)stringValue))}).method_23882(), (Object)ops.empty()));
            }
            return DataResult.error(() -> "Raw JSON input is not supported");
        }

        public <T> DataResult<T> encode(class_4550 input, DynamicOps<T> ops, T prefix) {
            return DataResult.error(() -> "Not supported yet");
        }
    };

    public static <T> Codec<T> simpleByNameCodec(Map<class_2960, T> map) {
        return class_2960.field_25139.flatXmap(key -> {
            Object value = map.get(key);
            if (value == null) {
                return DataResult.error(() -> "Unknown key: " + String.valueOf(key));
            }
            return DataResult.success(value);
        }, value -> DataResult.error(() -> "Unsupported operation"));
    }

    public static <T> Codec<T> simpleByNameCodec(BiMap<String, T> map) {
        return CustomizationCodecs.simpleByNameCodec(map, Codec.STRING);
    }

    public static <K, V> Codec<V> simpleByNameCodec(BiMap<K, V> map, Codec<K> keyCodec) {
        return keyCodec.flatXmap(key -> {
            Object value = map.get(key);
            if (value == null) {
                return DataResult.error(() -> "Unknown key: " + String.valueOf(key));
            }
            return DataResult.success((Object)value);
        }, value -> {
            Object key = map.inverse().get(value);
            if (key == null) {
                return DataResult.error(() -> "Unknown value: " + String.valueOf(value));
            }
            return DataResult.success((Object)key);
        });
    }

    public static <T> Codec<class_4970.class_4972<T>> stateArgumentPredicate() {
        return new Codec<class_4970.class_4972<T>>(){

            public <R> DataResult<R> encode(class_4970.class_4972<T> input, DynamicOps<R> ops, R prefix) {
                return DataResult.error(() -> "Unsupported operation");
            }

            public <R> DataResult<Pair<class_4970.class_4972<T>, R>> decode(DynamicOps<R> ops, R input) {
                String s;
                Optional booleanValue = ops.getBooleanValue(input).result();
                if (booleanValue.isPresent()) {
                    class_4970.class_4972 predicate = (Boolean)booleanValue.get() != false ? CustomizationCodecs::always : CustomizationCodecs::never;
                    return DataResult.success((Object)Pair.of((Object)predicate, (Object)ops.empty()));
                }
                Optional stringValue = ops.getStringValue(input).result();
                if (stringValue.isPresent() && "ocelot_or_parrot".equals(s = (String)stringValue.get())) {
                    return DataResult.success((Object)Pair.of((state, world, pos, entity) -> entity == class_1299.field_6081 || entity == class_1299.field_6104, (Object)ops.empty()));
                }
                return DataResult.error(() -> "Failed to decode state argument predicate: " + String.valueOf(input));
            }
        };
    }

    public static <T> boolean always(class_2680 blockState, class_1922 blockGetter, class_2338 pos, T t) {
        return true;
    }

    public static <T> boolean never(class_2680 blockState, class_1922 blockGetter, class_2338 pos, T t) {
        return false;
    }

    static {
        MAP_COLORS.put((Object)"none", (Object)class_3620.field_16008);
        MAP_COLORS.put((Object)"grass", (Object)class_3620.field_15999);
        MAP_COLORS.put((Object)"sand", (Object)class_3620.field_15986);
        MAP_COLORS.put((Object)"wool", (Object)class_3620.field_15979);
        MAP_COLORS.put((Object)"fire", (Object)class_3620.field_16002);
        MAP_COLORS.put((Object)"ice", (Object)class_3620.field_16016);
        MAP_COLORS.put((Object)"metal", (Object)class_3620.field_16005);
        MAP_COLORS.put((Object)"plant", (Object)class_3620.field_16004);
        MAP_COLORS.put((Object)"snow", (Object)class_3620.field_16022);
        MAP_COLORS.put((Object)"clay", (Object)class_3620.field_15976);
        MAP_COLORS.put((Object)"dirt", (Object)class_3620.field_16000);
        MAP_COLORS.put((Object)"stone", (Object)class_3620.field_16023);
        MAP_COLORS.put((Object)"water", (Object)class_3620.field_16019);
        MAP_COLORS.put((Object)"wood", (Object)class_3620.field_15996);
        MAP_COLORS.put((Object)"quartz", (Object)class_3620.field_16025);
        MAP_COLORS.put((Object)"color_orange", (Object)class_3620.field_15987);
        MAP_COLORS.put((Object)"color_magenta", (Object)class_3620.field_15998);
        MAP_COLORS.put((Object)"color_light_blue", (Object)class_3620.field_16024);
        MAP_COLORS.put((Object)"color_yellow", (Object)class_3620.field_16010);
        MAP_COLORS.put((Object)"color_light_green", (Object)class_3620.field_15997);
        MAP_COLORS.put((Object)"color_pink", (Object)class_3620.field_16030);
        MAP_COLORS.put((Object)"color_gray", (Object)class_3620.field_15978);
        MAP_COLORS.put((Object)"color_light_gray", (Object)class_3620.field_15993);
        MAP_COLORS.put((Object)"color_cyan", (Object)class_3620.field_16026);
        MAP_COLORS.put((Object)"color_purple", (Object)class_3620.field_16014);
        MAP_COLORS.put((Object)"color_blue", (Object)class_3620.field_15984);
        MAP_COLORS.put((Object)"color_brown", (Object)class_3620.field_15977);
        MAP_COLORS.put((Object)"color_green", (Object)class_3620.field_15995);
        MAP_COLORS.put((Object)"color_red", (Object)class_3620.field_16020);
        MAP_COLORS.put((Object)"color_black", (Object)class_3620.field_16009);
        MAP_COLORS.put((Object)"gold", (Object)class_3620.field_15994);
        MAP_COLORS.put((Object)"diamond", (Object)class_3620.field_15983);
        MAP_COLORS.put((Object)"lapis", (Object)class_3620.field_15980);
        MAP_COLORS.put((Object)"emerald", (Object)class_3620.field_16001);
        MAP_COLORS.put((Object)"podzol", (Object)class_3620.field_16017);
        MAP_COLORS.put((Object)"nether", (Object)class_3620.field_16012);
        MAP_COLORS.put((Object)"terracotta_white", (Object)class_3620.field_16003);
        MAP_COLORS.put((Object)"terracotta_orange", (Object)class_3620.field_15981);
        MAP_COLORS.put((Object)"terracotta_magenta", (Object)class_3620.field_15985);
        MAP_COLORS.put((Object)"terracotta_light_blue", (Object)class_3620.field_15991);
        MAP_COLORS.put((Object)"terracotta_yellow", (Object)class_3620.field_16013);
        MAP_COLORS.put((Object)"terracotta_light_green", (Object)class_3620.field_16018);
        MAP_COLORS.put((Object)"terracotta_pink", (Object)class_3620.field_15989);
        MAP_COLORS.put((Object)"terracotta_gray", (Object)class_3620.field_16027);
        MAP_COLORS.put((Object)"terracotta_light_gray", (Object)class_3620.field_15988);
        MAP_COLORS.put((Object)"terracotta_cyan", (Object)class_3620.field_15990);
        MAP_COLORS.put((Object)"terracotta_purple", (Object)class_3620.field_16029);
        MAP_COLORS.put((Object)"terracotta_blue", (Object)class_3620.field_16015);
        MAP_COLORS.put((Object)"terracotta_brown", (Object)class_3620.field_15992);
        MAP_COLORS.put((Object)"terracotta_green", (Object)class_3620.field_16028);
        MAP_COLORS.put((Object)"terracotta_red", (Object)class_3620.field_15982);
        MAP_COLORS.put((Object)"terracotta_black", (Object)class_3620.field_16007);
        MAP_COLORS.put((Object)"crimson_nylium", (Object)class_3620.field_25702);
        MAP_COLORS.put((Object)"crimson_stem", (Object)class_3620.field_25703);
        MAP_COLORS.put((Object)"crimson_hyphae", (Object)class_3620.field_25704);
        MAP_COLORS.put((Object)"warped_nylium", (Object)class_3620.field_25705);
        MAP_COLORS.put((Object)"warped_stem", (Object)class_3620.field_25706);
        MAP_COLORS.put((Object)"warped_hyphae", (Object)class_3620.field_25707);
        MAP_COLORS.put((Object)"warped_wart_block", (Object)class_3620.field_25708);
        MAP_COLORS.put((Object)"deepslate", (Object)class_3620.field_33532);
        MAP_COLORS.put((Object)"raw_iron", (Object)class_3620.field_33533);
        MAP_COLORS.put((Object)"glow_lichen", (Object)class_3620.field_33617);
        for (class_2766 instrument : class_2766.values()) {
            if (!instrument.method_47889()) continue;
            INSTRUMENTS.put((Object)instrument.method_15434(), (Object)instrument);
        }
    }
}

