/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import java.util.function.BooleanSupplier;
import net.minecraft.class_156;
import net.minecraft.class_304;
import net.minecraft.class_3675;

public class SmartKey
extends class_304 {
    private static final long SHORT_PRESS_MAX_MS = 200L;
    private static final long DOUBLE_PRESS_INTERVAL_MS = 200L;
    private static final long LONG_PRESS_MIN_MS = 400L;
    protected long pressSince = -1L;
    protected long lastShortPress = -1L;
    protected State state = State.Idle;
    private final BooleanSupplier onShortPress;
    private final BooleanSupplier onLongPress;
    private final BooleanSupplier onDoublePress;
    private final BooleanSupplier hasDoublePress;
    private final long longPressMinMs;

    private SmartKey(Builder builder) {
        super(builder.name, builder.type, builder.keyCode, builder.category);
        this.onShortPress = builder.onShortPress;
        this.onLongPress = builder.onLongPress;
        this.onDoublePress = builder.onDoublePress;
        this.hasDoublePress = builder.hasDoublePress;
        this.longPressMinMs = builder.longPressMinMs;
    }

    public void tick() {
        if (this.method_1415()) {
            return;
        }
        long time = class_156.method_658();
        if (this.method_1434()) {
            if (this.state != State.LongPress && this.pressSince != -1L && time - this.pressSince > this.longPressMinMs) {
                this.state = State.LongPress;
                this.onLongPress();
            }
        } else if (this.state == State.WaitingForDoublePress && time - this.lastShortPress > 200L) {
            this.onShortPress();
            this.pressSince = -1L;
            this.state = State.Idle;
        }
    }

    public void method_23481(boolean isDown) {
        this.setDownWithResult(isDown);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean setDownWithResult(boolean isDown) {
        boolean result;
        block8: {
            if (this.method_1434() == isDown) {
                return false;
            }
            super.method_23481(isDown);
            long time = class_156.method_658();
            result = false;
            if (isDown) {
                if (this.state == State.WaitingForDoublePress && time - this.lastShortPress < 200L) {
                    this.lastShortPress = -1L;
                    result = this.onDoublePress();
                    this.state = State.Idle;
                    break block8;
                } else {
                    this.pressSince = time;
                    this.state = State.ShortPress;
                    return false;
                }
            }
            if (this.state == State.ShortPress && time - this.pressSince < 200L) {
                this.lastShortPress = time;
                if (this.hasDoublePress()) {
                    this.state = State.WaitingForDoublePress;
                } else {
                    result = this.onShortPress();
                    this.state = State.Idle;
                }
            } else {
                this.state = State.Idle;
            }
        }
        this.pressSince = -1L;
        return result;
    }

    protected boolean hasDoublePress() {
        return this.onDoublePress != null && (this.hasDoublePress == null || this.hasDoublePress.getAsBoolean());
    }

    protected boolean onShortPress() {
        if (this.onShortPress != null) {
            return this.onShortPress.getAsBoolean();
        }
        return false;
    }

    protected boolean onLongPress() {
        if (this.onLongPress != null) {
            return this.onLongPress.getAsBoolean();
        }
        return false;
    }

    protected boolean onDoublePress() {
        if (this.onDoublePress != null) {
            return this.onDoublePress.getAsBoolean();
        }
        return false;
    }

    public static class Builder {
        private final String name;
        private final String category;
        private class_3675.class_307 type = class_3675.class_307.field_1668;
        private int keyCode = -1;
        private BooleanSupplier onShortPress;
        private BooleanSupplier onLongPress;
        private BooleanSupplier onDoublePress;
        private BooleanSupplier hasDoublePress;
        private long longPressMinMs = 400L;

        public Builder(String name, String category) {
            this.name = name;
            this.category = category;
        }

        public Builder key(class_3675.class_306 key) {
            this.type = key.method_1442();
            this.keyCode = key.method_1444();
            return this;
        }

        public Builder onShortPress(BooleanSupplier onShortPress) {
            this.onShortPress = onShortPress;
            return this;
        }

        public Builder onLongPress(BooleanSupplier onLongPress) {
            this.onLongPress = onLongPress;
            return this;
        }

        public Builder onDoublePress(BooleanSupplier onDoublePress) {
            this.onDoublePress = onDoublePress;
            return this;
        }

        public Builder hasDoublePress(BooleanSupplier hasDoublePress) {
            this.hasDoublePress = hasDoublePress;
            return this;
        }

        public SmartKey build() {
            return new SmartKey(this);
        }

        public Builder longPressMinMs(long longPressMinMs) {
            this.longPressMinMs = longPressMinMs;
            return this;
        }
    }

    public static enum State {
        Idle,
        ShortPress,
        WaitingForDoublePress,
        LongPress;

    }
}

