/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_2248;
import net.minecraft.class_2902;
import net.minecraft.class_4048;
import net.minecraft.class_5132;
import net.minecraft.class_7696;
import net.minecraft.class_9168;
import org.jetbrains.annotations.Nullable;

public class KiwiEntityTypeBuilder<T extends class_1297> {
    private final Class<?> type;
    private class_1299.class_4049<T> factory;
    private class_1311 category = class_1311.field_17715;
    private class_2248[] immuneTo;
    private boolean serialize = true;
    private boolean summon = true;
    private boolean fireImmune;
    private boolean canSpawnFarFromPlayer;
    private int clientTrackingRange = 5;
    private int updateInterval = 3;
    private class_4048 dimensions = class_4048.method_18384((float)-1.0f, (float)-1.0f);
    private class_7696[] requiredFeatures;
    private Boolean forceTrackedVelocityUpdates;
    @Nullable
    private Supplier<class_5132.class_5133> defaultAttributeBuilder;
    private class_9168 restrictionLocation;
    private class_2902.class_2903 restrictionHeightmap;
    private class_1317.class_4306<T> spawnPredicate;

    private KiwiEntityTypeBuilder(Class<?> type) {
        this.type = type;
    }

    public static <T extends class_1297> KiwiEntityTypeBuilder<T> create() {
        return new KiwiEntityTypeBuilder<T>(class_1297.class);
    }

    public static <T extends class_1309> KiwiEntityTypeBuilder<T> createLiving() {
        return new KiwiEntityTypeBuilder<T>(class_1309.class);
    }

    public static <T extends class_1297> KiwiEntityTypeBuilder<T> createMob() {
        return new KiwiEntityTypeBuilder<T>(class_1308.class);
    }

    public KiwiEntityTypeBuilder<T> spawnGroup(class_1311 group) {
        Objects.requireNonNull(group, "Spawn group cannot be null");
        this.category = group;
        return this;
    }

    public <N extends T> KiwiEntityTypeBuilder<N> entityFactory(class_1299.class_4049<N> factory) {
        Objects.requireNonNull(factory, "Entity Factory cannot be null");
        this.factory = factory;
        return this;
    }

    public KiwiEntityTypeBuilder<T> dimensions(class_4048 dimensions) {
        Objects.requireNonNull(dimensions, "Cannot set null dimensions");
        this.dimensions = dimensions;
        return this;
    }

    public KiwiEntityTypeBuilder<T> disableSummon() {
        this.summon = false;
        return this;
    }

    public KiwiEntityTypeBuilder<T> disableSaving() {
        this.serialize = false;
        return this;
    }

    public KiwiEntityTypeBuilder<T> fireImmune() {
        this.fireImmune = true;
        return this;
    }

    public KiwiEntityTypeBuilder<T> specificSpawnBlocks(class_2248 ... blocks) {
        this.immuneTo = blocks;
        return this;
    }

    public KiwiEntityTypeBuilder<T> spawnableFarFromPlayer() {
        this.canSpawnFarFromPlayer = true;
        return this;
    }

    public KiwiEntityTypeBuilder<T> trackRangeChunks(int i) {
        this.clientTrackingRange = i;
        return this;
    }

    public KiwiEntityTypeBuilder<T> trackedUpdateRate(int i) {
        this.updateInterval = i;
        return this;
    }

    public KiwiEntityTypeBuilder<T> requiredFeatures(class_7696 ... featureFlags) {
        this.requiredFeatures = featureFlags;
        return this;
    }

    public KiwiEntityTypeBuilder<T> forceTrackedVelocityUpdates(boolean forceTrackedVelocityUpdates) {
        this.forceTrackedVelocityUpdates = forceTrackedVelocityUpdates;
        return this;
    }

    public KiwiEntityTypeBuilder<T> defaultAttributes(Supplier<class_5132.class_5133> defaultAttributeBuilder) {
        Objects.requireNonNull(defaultAttributeBuilder, "Cannot set null attribute builder");
        Preconditions.checkState((this.type == class_1309.class || this.type == class_1308.class ? 1 : 0) != 0, (Object)"Only living entities can have default attributes.");
        this.defaultAttributeBuilder = defaultAttributeBuilder;
        return this;
    }

    public KiwiEntityTypeBuilder<T> spawnRestriction(class_9168 location, class_2902.class_2903 heightmap, class_1317.class_4306<T> spawnPredicate) {
        Preconditions.checkState((this.type == class_1308.class ? 1 : 0) != 0, (Object)"Only mobs can have spawn restrictions.");
        this.restrictionLocation = Objects.requireNonNull(location, "Location cannot be null.");
        this.restrictionHeightmap = Objects.requireNonNull(heightmap, "Heightmap type cannot be null.");
        this.spawnPredicate = Objects.requireNonNull(spawnPredicate, "Spawn predicate cannot be null.");
        return this;
    }

    public class_1299<T> build() {
        FabricEntityTypeBuilder builder;
        if (this.type == class_1297.class) {
            builder = FabricEntityTypeBuilder.create();
        } else if (this.type == class_1309.class) {
            FabricEntityTypeBuilder.Living rawBuilder = FabricEntityTypeBuilder.createLiving();
            if (this.defaultAttributeBuilder != null) {
                rawBuilder.defaultAttributes(this.defaultAttributeBuilder);
            }
            builder = rawBuilder;
        } else if (this.type == class_1308.class) {
            FabricEntityTypeBuilder.Mob rawBuilder = FabricEntityTypeBuilder.createMob();
            if (this.defaultAttributeBuilder != null) {
                rawBuilder.defaultAttributes(this.defaultAttributeBuilder);
            }
            if (this.spawnPredicate != null) {
                rawBuilder.spawnRestriction(this.restrictionLocation, this.restrictionHeightmap, this.spawnPredicate);
            }
            builder = rawBuilder;
        } else {
            throw new IllegalStateException("Unknown entity type: " + String.valueOf(this.type));
        }
        builder.spawnGroup(this.category);
        builder.dimensions(this.dimensions);
        builder.trackRangeChunks(this.clientTrackingRange);
        builder.trackedUpdateRate(this.updateInterval);
        if (this.factory != null) {
            builder.entityFactory(this.factory);
        }
        if (!this.serialize) {
            builder.disableSaving();
        }
        if (!this.summon) {
            builder.disableSummon();
        }
        if (this.fireImmune) {
            builder.fireImmune();
        }
        if (this.immuneTo != null) {
            builder.specificSpawnBlocks(this.immuneTo);
        }
        if (this.canSpawnFarFromPlayer) {
            builder.spawnableFarFromPlayer();
        }
        if (this.forceTrackedVelocityUpdates != null) {
            builder.forceTrackedVelocityUpdates(this.forceTrackedVelocityUpdates.booleanValue());
        }
        if (this.requiredFeatures != null) {
            builder.requires(this.requiredFeatures);
        }
        return builder.build();
    }
}

