/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.network;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import snownee.kiwi.KiwiAnnotationData;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.network.KiwiPacket;
import snownee.kiwi.network.PlayPacketHandler;

public final class KNetworking {
    private KNetworking() {
    }

    public static synchronized <T extends class_8710> void registerPlayHandler(class_8710.class_9154<T> type, PlayPacketHandler<T> handler, KiwiPacket.Direction direction) {
        Preconditions.checkArgument((direction != KiwiPacket.Direction.AUTO ? 1 : 0) != 0, (Object)"Direction must be specified");
        if (direction == KiwiPacket.Direction.TO_CLIENT) {
            PayloadTypeRegistry.playS2C().register(type, handler.streamCodec());
            if (Platform.isPhysicalClient()) {
                ClientPlayNetworking.registerGlobalReceiver(type, (payload, context) -> handler.handle(payload, arg_0 -> ((class_310)context.client()).execute(arg_0)));
            }
        } else if (direction == KiwiPacket.Direction.TO_SERVER) {
            PayloadTypeRegistry.playC2S().register(type, handler.streamCodec());
            ServerPlayNetworking.registerGlobalReceiver(type, (payload, context) -> handler.handle(payload, () -> ((ServerPlayNetworking.Context)context).player()));
        }
    }

    public static void processClass(KiwiAnnotationData annotationData) {
        try {
            Class<?> handlerClass;
            String packetClassName = annotationData.getTarget();
            if (Platform.isProduction() && packetClassName.startsWith("snownee.kiwi.test.")) {
                return;
            }
            Class<?> packetClass = Class.forName(packetClassName);
            Field field = packetClass.getDeclaredField("TYPE");
            class_8710.class_9154 type = (class_8710.class_9154)field.get(null);
            KiwiPacket annotation = packetClass.getDeclaredAnnotation(KiwiPacket.class);
            KiwiPacket.Direction direction = annotation.dir();
            if (direction == KiwiPacket.Direction.AUTO) {
                String simpleName = packetClass.getSimpleName();
                char firstChar = simpleName.charAt(0);
                Preconditions.checkState((firstChar == 'C' || firstChar == 'S' ? 1 : 0) != 0, (String)"Packet class name must be '[CS][A-Z]', but got '%s'", (Object)simpleName);
                Preconditions.checkState((boolean)Character.isUpperCase(simpleName.charAt(1)), (String)"Packet class name must be '[CS][A-Z]', but got '%s'", (Object)simpleName);
                direction = firstChar == 'C' ? KiwiPacket.Direction.TO_SERVER : KiwiPacket.Direction.TO_CLIENT;
            }
            if (PlayPacketHandler.class.isAssignableFrom(handlerClass = Class.forName(packetClassName + "$Handler"))) {
                PlayPacketHandler handler = (PlayPacketHandler)handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                handler.register(type, direction);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

