/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.shape;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.class_2248;
import net.minecraft.class_2544;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import snownee.kiwi.customization.shape.BlockShapeType;
import snownee.kiwi.customization.shape.ConfiguringShape;
import snownee.kiwi.customization.shape.ShapeStorage;

public record ConfigureWallShape(float width, float depth, float wallPostHeight, float wallMinY, float wallLowHeight, float wallTallHeight) implements ConfiguringShape
{
    public static Codec<ConfigureWallShape> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("post_width").forGetter(ConfigureWallShape::width), (App)Codec.FLOAT.fieldOf("side_width").forGetter(ConfigureWallShape::depth), (App)Codec.FLOAT.fieldOf("post_max_y").forGetter(ConfigureWallShape::wallPostHeight), (App)Codec.FLOAT.fieldOf("side_min_y").forGetter(ConfigureWallShape::wallMinY), (App)Codec.FLOAT.fieldOf("low_side_max_y").forGetter(ConfigureWallShape::wallLowHeight), (App)Codec.FLOAT.fieldOf("tall_side_max_y").forGetter(ConfigureWallShape::wallTallHeight)).apply((Applicative)instance, ConfigureWallShape::new));
    }

    @Override
    public void configure(class_2248 block, BlockShapeType type, ShapeStorage storage) {
        if (!(block instanceof class_2544)) {
            throw new IllegalArgumentException("Block %s is not a WallBlock".formatted(block));
        }
        class_2544 wallBlock = (class_2544)block;
        Map shapes = wallBlock.method_24420(this.width / 2.0f, this.depth / 2.0f, this.wallPostHeight, this.wallMinY, this.wallLowHeight, this.wallTallHeight);
        switch (type) {
            case MAIN: {
                wallBlock.field_22161 = shapes;
                break;
            }
            case COLLISION: {
                wallBlock.field_22162 = shapes;
                break;
            }
            case INTERACTION: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void replaceAll(class_2248 block, BlockShapeType type, UnaryOperator<class_265> operator) {
        if (!(block instanceof class_2544)) {
            throw new IllegalArgumentException("Block %s is not a WallBlock".formatted(block));
        }
        class_2544 wallBlock = (class_2544)block;
        if (type == BlockShapeType.INTERACTION) {
            throw new UnsupportedOperationException("Interaction shapes cannot be replaced for WallBlock");
        }
        Map shapes = switch (type) {
            case BlockShapeType.MAIN -> wallBlock.field_22161;
            case BlockShapeType.COLLISION -> wallBlock.field_22162;
            default -> throw new IllegalStateException();
        };
        IdentityHashMap newShapes = Maps.newIdentityHashMap();
        for (Map.Entry entry : shapes.entrySet()) {
            newShapes.put((class_2680)entry.getKey(), (class_265)operator.apply((class_265)entry.getValue()));
        }
        switch (type) {
            case MAIN: {
                wallBlock.field_22161 = newShapes;
                break;
            }
            case COLLISION: {
                wallBlock.field_22162 = newShapes;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }
}

