/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.shape;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.class_2248;
import net.minecraft.class_2310;
import net.minecraft.class_265;
import snownee.kiwi.customization.shape.BlockShapeType;
import snownee.kiwi.customization.shape.ConfiguringShape;
import snownee.kiwi.customization.shape.ShapeStorage;

public record ConfigureCrossCollisionShape(float nodeWidth, float extensionWidth, float nodeHeight, float extensionBottom, float extensionHeight) implements ConfiguringShape
{
    public static Codec<ConfigureCrossCollisionShape> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("post_width").forGetter(ConfigureCrossCollisionShape::nodeWidth), (App)Codec.FLOAT.fieldOf("side_width").forGetter(ConfigureCrossCollisionShape::extensionWidth), (App)Codec.FLOAT.fieldOf("post_max_y").forGetter(ConfigureCrossCollisionShape::nodeHeight), (App)Codec.FLOAT.fieldOf("side_min_y").forGetter(ConfigureCrossCollisionShape::extensionBottom), (App)Codec.FLOAT.fieldOf("side_max_y").forGetter(ConfigureCrossCollisionShape::extensionHeight)).apply((Applicative)instance, ConfigureCrossCollisionShape::new));
    }

    @Override
    public void configure(class_2248 block, BlockShapeType type, ShapeStorage storage) {
        if (!(block instanceof class_2310)) {
            throw new IllegalArgumentException("Block %s is not a CrossCollisionBlock".formatted(block));
        }
        class_2310 crossCollisionBlock = (class_2310)block;
        class_265[] shapes = crossCollisionBlock.method_9984(this.nodeWidth / 2.0f, this.extensionWidth / 2.0f, this.nodeHeight, this.extensionBottom, this.extensionHeight);
        switch (type) {
            case MAIN: {
                crossCollisionBlock.field_10906 = shapes;
                break;
            }
            case COLLISION: {
                crossCollisionBlock.field_10901 = shapes;
                break;
            }
            case INTERACTION: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void replaceAll(class_2248 block, BlockShapeType type, UnaryOperator<class_265> operator) {
        if (!(block instanceof class_2310)) {
            throw new IllegalArgumentException("Block %s is not a CrossCollisionBlock".formatted(block));
        }
        class_2310 crossCollisionBlock = (class_2310)block;
        switch (type) {
            case MAIN: {
                crossCollisionBlock.field_10906 = (class_265[])Stream.of(crossCollisionBlock.field_10906).map(operator).toArray(class_265[]::new);
                break;
            }
            case COLLISION: {
                crossCollisionBlock.field_10901 = (class_265[])Stream.of(crossCollisionBlock.field_10901).map(operator).toArray(class_265[]::new);
                break;
            }
            case INTERACTION: {
                throw new UnsupportedOperationException();
            }
        }
    }
}

