/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.shape;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_5699;
import snownee.kiwi.customization.block.KBlockUtils;
import snownee.kiwi.customization.shape.BakingContext;
import snownee.kiwi.customization.shape.ShapeGenerator;
import snownee.kiwi.customization.shape.UnbakedShape;
import snownee.kiwi.customization.shape.UnbakedShapeCodec;

public record ChoicesShape(List<String> keys, Map<String, ShapeGenerator> valueMap) implements ShapeGenerator
{
    public static <T extends Comparable<T>> ShapeGenerator chooseOneProperty(class_2769<T> property, Map<T, ShapeGenerator> valueMap) {
        return new ChoicesShape(List.of(property.method_11899()), property.method_11898().stream().collect(Collectors.toUnmodifiableMap(arg_0 -> property.method_11901(arg_0), valueMap::get)));
    }

    public static ShapeGenerator chooseBooleanProperty(class_2746 property, ShapeGenerator trueShape, ShapeGenerator falseShape) {
        return new ChoicesShape(List.of(property.method_11899()), Map.of("true", trueShape, "false", falseShape));
    }

    @Override
    public class_265 getShape(class_2680 blockState, class_3726 context) {
        String key = this.keys.size() == 1 ? KBlockUtils.getValueString(blockState, this.keys.get(0)) : String.join((CharSequence)",", (CharSequence[])this.keys.stream().map(k -> KBlockUtils.getValueString(blockState, k)).toArray(String[]::new));
        return this.valueMap.get(key).getShape(blockState, context);
    }

    public record Unbaked(List<String> keys, Map<String, UnbakedShape> choices) implements UnbakedShape
    {
        public static Codec<Unbaked> codec(UnbakedShapeCodec parentCodec) {
            Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_41759.listOf().fieldOf("keys").forGetter(Unbaked::keys), (App)Codec.unboundedMap((Codec)class_5699.field_41759, (Codec)parentCodec).fieldOf("choices").forGetter(Unbaked::choices)).apply((Applicative)instance, Unbaked::new));
            return codec.validate($ -> {
                if ($.keys().isEmpty()) {
                    return DataResult.error(() -> "Keys must not be empty");
                }
                if ($.choices().isEmpty()) {
                    throw new IllegalArgumentException("Choices must not be empty");
                }
                return DataResult.success((Object)$);
            });
        }

        @Override
        public ShapeGenerator bake(BakingContext context) {
            return new ChoicesShape(this.keys, this.choices.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> ((UnbakedShape)e.getValue()).bake(context))));
        }

        @Override
        public Stream<UnbakedShape> dependencies() {
            return this.choices.values().stream();
        }
    }
}

