/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.network;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_7995;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import snownee.kiwi.Kiwi;
import snownee.kiwi.KiwiCommonConfig;
import snownee.kiwi.customization.block.family.BlockFamilies;
import snownee.kiwi.customization.block.family.BlockFamily;
import snownee.kiwi.customization.network.SItemPopTimePacket;
import snownee.kiwi.network.KiwiPacket;
import snownee.kiwi.network.PayloadContext;
import snownee.kiwi.network.PlayPacketHandler;
import snownee.kiwi.util.KHolder;

@KiwiPacket
public record CConvertItemPacket(boolean inContainer, Action action, int slot, class_6880<class_1792> from, Entry entry) implements class_8710
{
    public static final class_8710.class_9154<CConvertItemPacket> TYPE = new class_8710.class_9154(Kiwi.id("convert_item"));
    public static final int MAX_STEPS = 4;

    public CConvertItemPacket(boolean inContainer, int slot, Entry entry, class_1792 from, Action action) {
        this(inContainer, action, slot, (class_6880<class_1792>)from.method_40131(), entry);
    }

    public class_8710.class_9154<CConvertItemPacket> method_56479() {
        return TYPE;
    }

    public static enum Action {
        CONVERT_ALL,
        CONVERT_ONE,
        CONVERT_FAMILY;

        private static final IntFunction<Action> BY_ID;
        public static final class_9139<ByteBuf, Action> STREAM_CODEC;

        static {
            BY_ID = class_7995.method_47914(Enum::ordinal, (Object[])Action.values(), (class_7995.class_7996)class_7995.class_7996.field_41664);
            STREAM_CODEC = class_9135.method_56375(BY_ID, Enum::ordinal);
        }
    }

    public record Entry(float ratio, List<Pair<class_2960, class_1792>> steps) {
        public static final class_9139<class_9129, Pair<class_2960, class_1792>> ENTRY_PAIR_STREAM_CODEC = class_9139.method_56435((class_9139)class_2960.field_48267, Pair::getFirst, (class_9139)class_9135.method_56365((class_5321)class_7924.field_41197), Pair::getSecond, Pair::of);
        public static final class_9139<class_9129, Entry> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.field_48552, Entry::ratio, (class_9139)class_9135.method_56376(ArrayList::new, ENTRY_PAIR_STREAM_CODEC), Entry::steps, Entry::new);

        public Entry(float ratio) {
            this(ratio, Lists.newArrayList());
        }

        public class_1792 item() {
            return (class_1792)this.steps.getLast().getSecond();
        }
    }

    public record Group(List<Entry> entries) {
        public Group() {
            this(Lists.newArrayList());
        }
    }

    public static class Handler
    implements PlayPacketHandler<CConvertItemPacket> {
        public static final class_9139<class_9129, CConvertItemPacket> STREAM_CODEC = class_9139.method_56906((class_9139)class_9135.field_48547, CConvertItemPacket::inContainer, Action.STREAM_CODEC, CConvertItemPacket::action, (class_9139)class_9135.field_48550, CConvertItemPacket::slot, (class_9139)class_9135.method_56383((class_5321)class_7924.field_41197), CConvertItemPacket::from, Entry.STREAM_CODEC, CConvertItemPacket::entry, CConvertItemPacket::new);

        @Override
        public void handle(CConvertItemPacket packet, PayloadContext context) {
            class_3222 player = context.serverPlayer();
            if (KiwiCommonConfig.kSwitchCreativeOnly && !player.method_7337()) {
                return;
            }
            Action action = packet.action;
            boolean inContainer = packet.inContainer;
            int slotIndex = packet.slot;
            class_1792 from = (class_1792)packet.from.comp_349();
            List<Pair<class_2960, class_1792>> steps = packet.entry.steps;
            if (steps.isEmpty() || steps.size() > 4) {
                return;
            }
            if (action == Action.CONVERT_FAMILY && inContainer) {
                return;
            }
            class_1792 to = (class_1792)steps.getLast().getSecond();
            context.execute(() -> {
                class_1799 newItem;
                class_1799 sourceItem;
                class_1792 item = from;
                int index = 0;
                float ratio = 1.0f;
                for (Pair step : steps) {
                    BlockFamily family = BlockFamilies.get((class_2960)step.getFirst());
                    if (!(family != null && family.switchAttrs().enabled() && family.contains(item) && family.contains((class_1792)step.getSecond()))) {
                        return;
                    }
                    if (!family.switchAttrs().cascading() && index != steps.size() - 1) {
                        return;
                    }
                    if (!player.method_7337()) {
                        ratio *= BlockFamilies.getConvertRatio(item) / BlockFamilies.getConvertRatio((class_1792)step.getSecond());
                    }
                    item = (class_1792)step.getSecond();
                    ++index;
                }
                class_1735 slot = null;
                class_1661 playerInventory = player.method_31548();
                try {
                    if (slotIndex == -500) {
                        if (!player.method_7337()) return;
                        sourceItem = from.method_7854();
                    } else if (inContainer) {
                        slot = (class_1735)player.field_7512.field_7761.get(slotIndex);
                        if (!slot.method_32754((class_1657)player)) {
                            return;
                        }
                        sourceItem = slot.method_7677();
                    } else {
                        sourceItem = playerInventory.method_5438(slotIndex);
                    }
                }
                catch (Exception e) {
                    return;
                }
                if (!sourceItem.method_31574(from)) {
                    return;
                }
                if (action == Action.CONVERT_FAMILY) {
                    Handler.convertFamily(player, to, slotIndex, ratio);
                    return;
                }
                boolean skipSettingSlot = false;
                int inventorySwap = Integer.MIN_VALUE;
                if (ratio >= 1.0f) {
                    newItem = to.method_7854();
                } else {
                    if (action == Action.CONVERT_ONE) {
                        return;
                    }
                    for (int i = 0; i < playerInventory.method_5439(); ++i) {
                        class_1799 stack = playerInventory.method_5438(i);
                        if (!stack.method_31574(to)) continue;
                        inventorySwap = i;
                        break;
                    }
                    if (inventorySwap == Integer.MIN_VALUE) {
                        return;
                    }
                    newItem = playerInventory.method_5438(inventorySwap);
                }
                int ratioInt = class_3532.method_15375((float)ratio);
                if (action == Action.CONVERT_ONE) {
                    if (!player.method_7337()) {
                        sourceItem.method_7934(1);
                        newItem.method_7939(ratioInt);
                    }
                    if (!sourceItem.method_7960()) {
                        Handler.addToPlayer(player, newItem, !inContainer);
                        skipSettingSlot = true;
                    }
                } else if (inventorySwap == Integer.MIN_VALUE) {
                    int maxSize = newItem.method_7914();
                    int count = Math.min(sourceItem.method_7947(), maxSize / ratioInt);
                    newItem.method_7939(count * ratioInt);
                    if (!player.method_7337()) {
                        sourceItem.method_7934(count);
                    }
                }
                if (slotIndex != -500 && !skipSettingSlot) {
                    try {
                        if (inContainer) {
                            if (!slot.method_7680(newItem)) {
                                return;
                            }
                            slot.method_53512(newItem);
                        } else {
                            newItem.method_7912(5);
                            playerInventory.method_5447(slotIndex, newItem);
                        }
                    }
                    catch (Exception e) {
                        return;
                    }
                }
                if (inventorySwap != Integer.MIN_VALUE) {
                    playerInventory.method_5447(inventorySwap, sourceItem);
                } else if (!skipSettingSlot && !player.method_7337()) {
                    Handler.addToPlayer(player, sourceItem.method_7972(), !inContainer);
                }
                Handler.broadcastChanges(player);
            });
        }

        private static void broadcastChanges(class_3222 player) {
            class_1661 inventory = player.method_31548();
            boolean success = false;
            for (int i = 0; i < inventory.method_5439(); ++i) {
                success |= SItemPopTimePacket.send(player, i);
            }
            if (success) {
                Handler.playPickupSound((class_1657)player);
                player.field_7512.method_7623();
            }
        }

        public static void convertFamily(class_3222 player, class_1792 to, int slotIndex, float ratio) {
            Set set = BlockFamilies.findQuickSwitch(to, player.method_7337()).stream().map(KHolder::value).flatMap(BlockFamily::items).filter(Predicate.not(to::equals)).collect(Collectors.toSet());
            class_1661 inventory = player.method_31548();
            boolean success = false;
            for (int i = 0; i < inventory.method_5439(); ++i) {
                class_1799 stack = inventory.method_5438(i);
                if (!set.contains(stack.method_7909())) continue;
                success = true;
                inventory.method_5447(i, class_1799.field_8037);
                class_1799 newItem = to.method_7854();
                newItem.method_7912(5);
                int newCount = class_3532.method_15375((float)((float)stack.method_7947() * ratio));
                while (newCount > 0) {
                    int count = Math.min(newCount, newItem.method_7914());
                    newItem.method_7939(count);
                    newCount -= count;
                    if (!inventory.method_7367(slotIndex, newItem) && !inventory.method_7394(newItem)) {
                        player.method_7328(newItem, true);
                    }
                    if (newCount <= 0) continue;
                    newItem = newItem.method_7972();
                }
            }
            if (success) {
                Handler.broadcastChanges(player);
            }
        }

        @Override
        public class_9139<class_9129, CConvertItemPacket> streamCodec() {
            return STREAM_CODEC;
        }

        private static void addToPlayer(class_3222 player, class_1799 itemStack, boolean nextToSelected) {
            int slot;
            class_1661 inventory = player.method_31548();
            IntStream intStream = IntStream.range(0, 9);
            if (nextToSelected) {
                IntStream leftAndRight = IntStream.of(inventory.field_7545, inventory.field_7545 + 1, inventory.field_7545 - 1);
                intStream = IntStream.concat(leftAndRight, intStream);
            }
            if (!(inventory.method_7367(slot = intStream.filter(class_1661::method_7380).filter(i -> {
                class_1799 stack = inventory.method_5438(i);
                if (stack.method_7960()) {
                    return true;
                }
                return stack.method_7947() < stack.method_7914() && class_1799.method_31577((class_1799)stack, (class_1799)itemStack);
            }).findFirst().orElse(-1), itemStack) || inventory.method_7394(itemStack) || player.method_7337())) {
                player.method_7328(itemStack, true);
            }
        }

        public static void playPickupSound(class_1657 player) {
            player.method_37908().method_43128((class_1657)(player.method_7340() ? player : null), player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, ((player.method_59922().method_43057() - player.method_59922().method_43057()) * 0.7f + 1.0f) * 2.0f);
        }
    }
}

