/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1838;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_7995;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import snownee.kiwi.Kiwi;
import snownee.kiwi.customization.builder.BuilderRule;
import snownee.kiwi.customization.builder.BuilderRules;
import snownee.kiwi.network.KiwiPacket;
import snownee.kiwi.network.PayloadContext;
import snownee.kiwi.network.PlayPacketHandler;
import snownee.kiwi.util.KHolder;

@KiwiPacket
public record CApplyBuilderRulePacket(class_1268 hand, class_2338 clickPos, class_2960 key, List<class_2338> positions) implements class_8710
{
    public static final class_8710.class_9154<CApplyBuilderRulePacket> TYPE = new class_8710.class_9154(Kiwi.id("apply_builder_rule"));

    public CApplyBuilderRulePacket(class_1838 context, KHolder<BuilderRule> holder, List<class_2338> positions) {
        this(context.method_20287(), context.method_8037(), holder.key(), positions);
    }

    public class_8710.class_9154<CApplyBuilderRulePacket> method_56479() {
        return TYPE;
    }

    public static class Handler
    implements PlayPacketHandler<CApplyBuilderRulePacket> {
        public static final class_9139<ByteBuf, class_1268> HAND_STREAM_CODEC = class_9135.method_56375((IntFunction)class_7995.method_47914(Enum::ordinal, (Object[])class_1268.values(), (class_7995.class_7996)class_7995.class_7996.field_41665), Enum::ordinal);
        public static final class_9139<class_9129, CApplyBuilderRulePacket> STREAM_CODEC = class_9139.method_56905(HAND_STREAM_CODEC, CApplyBuilderRulePacket::hand, (class_9139)class_2338.field_48404, CApplyBuilderRulePacket::clickPos, (class_9139)class_2960.field_48267, CApplyBuilderRulePacket::key, (class_9139)class_9135.method_56376(ArrayList::new, (class_9139)class_2338.field_48404), CApplyBuilderRulePacket::positions, CApplyBuilderRulePacket::new);

        @Override
        public void handle(CApplyBuilderRulePacket packet, PayloadContext context) {
            class_3222 player = context.serverPlayer();
            class_1268 hand = packet.hand;
            class_2338 pos = packet.clickPos;
            class_2960 ruleId = packet.key;
            List<class_2338> positions = packet.positions;
            if (Stream.concat(Stream.of(pos), positions.stream()).anyMatch($ -> !player.method_37908().method_8477($))) {
                return;
            }
            context.execute(() -> {
                class_3965 blockHitResult;
                BuilderRule rule = BuilderRules.get(ruleId);
                if (rule == null) {
                    return;
                }
                class_239 hitResult = player.method_5745(10.0, 1.0f, false);
                if (!(hitResult instanceof class_3965) || !(blockHitResult = (class_3965)hitResult).method_17777().equals((Object)pos)) {
                    return;
                }
                class_2680 blockState = player.method_37908().method_8320(pos);
                class_2248 block = blockState.method_26204();
                if (rule.relatedBlocks().noneMatch(block::equals)) {
                    return;
                }
                class_1838 useOnContext = new class_1838((class_1657)player, hand, blockHitResult);
                if (rule.matches((class_1657)player, useOnContext.method_8041(), blockState)) {
                    rule.apply(useOnContext, positions);
                }
            });
        }

        @Override
        public class_9139<class_9129, CApplyBuilderRulePacket> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

