/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.command;

import com.google.common.collect.Maps;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.TreeMap;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import snownee.kiwi.customization.CustomizationHooks;
import snownee.kiwi.customization.block.BlockFundamentals;
import snownee.kiwi.customization.shape.ShapeGenerator;
import snownee.kiwi.customization.shape.UnbakedShapeCodec;
import snownee.kiwi.util.resource.OneTimeLoader;

public class ExportShapesCommand {
    public static void register(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(class_2170.method_9247((String)"shapes").executes(ctx -> ExportShapesCommand.exportShapes((class_2168)ctx.getSource())));
    }

    private static int exportShapes(class_2168 source) {
        TreeMap data = Maps.newTreeMap();
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get("exported_shapes.json", new String[0]), new OpenOption[0]);){
            BlockFundamentals fundamentals = BlockFundamentals.reload(CustomizationHooks.collectKiwiPacks(), new OneTimeLoader.Context(), false);
            fundamentals.shapes().forEach((key, value) -> {
                if (value.getClass() != ShapeGenerator.Unit.class) {
                    return;
                }
                String string = key.toString();
                if ("minecraft:empty".equals(string) || "minecraft:block".equals(string)) {
                    return;
                }
                data.put(string, UnbakedShapeCodec.encodeVoxelShape(ShapeGenerator.Unit.unboxOrThrow(value)));
            });
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)data, (Appendable)writer);
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)e.getMessage()));
            return 0;
        }
        source.method_9226(() -> class_2561.method_43470((String)"Shapes exported"), false);
        return 1;
    }
}

