/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.loader;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import snownee.kiwi.customization.block.BlockFundamentals;
import snownee.kiwi.customization.block.loader.BlockCodecs;
import snownee.kiwi.customization.block.loader.BlockDefinitionProperties;
import snownee.kiwi.customization.block.loader.KBlockTemplate;
import snownee.kiwi.customization.block.loader.KBlockTemplates;
import snownee.kiwi.util.resource.OneTimeLoader;

public final class SimpleBlockTemplate
extends KBlockTemplate {
    private final String clazz;
    private Function<class_4970.class_2251, class_2248> constructor;

    public SimpleBlockTemplate(Optional<BlockDefinitionProperties> properties, String clazz) {
        super(properties);
        this.clazz = clazz;
    }

    public static MapCodec<SimpleBlockTemplate> directCodec(BlockFundamentals.CodecCreationContext context) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockDefinitionProperties.mapCodecField(context).forGetter(KBlockTemplate::properties), (App)Codec.STRING.optionalFieldOf("class", (Object)"").forGetter(SimpleBlockTemplate::clazz)).apply((Applicative)instance, SimpleBlockTemplate::new));
    }

    @Override
    public KBlockTemplate.Type<?> type() {
        return KBlockTemplates.SIMPLE.getOrCreate();
    }

    @Override
    public void resolve(class_2960 key, OneTimeLoader.Context context) {
        if (this.clazz.isEmpty()) {
            this.constructor = BlockCodecs.SIMPLE_BLOCK_FACTORY;
            return;
        }
        try {
            Class<?> clazz = Class.forName(this.clazz);
            this.constructor = $ -> {
                try {
                    return (class_2248)clazz.getConstructor(class_4970.class_2251.class).newInstance($);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public class_2248 createBlock(class_2960 id, class_4970.class_2251 settings, JsonObject input) {
        return this.constructor.apply(settings);
    }

    public String clazz() {
        return this.clazz;
    }

    public String toString() {
        return "SimpleBlockTemplate[properties=" + String.valueOf(this.properties) + ", clazz=" + this.clazz + ", constructor=" + String.valueOf(this.constructor) + "]";
    }
}

