/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.loader;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_7923;
import snownee.kiwi.Kiwi;
import snownee.kiwi.customization.CustomizationRegistries;
import snownee.kiwi.customization.block.BlockFundamentals;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.block.behavior.BlockBehaviorRegistry;
import snownee.kiwi.customization.block.component.KBlockComponent;
import snownee.kiwi.customization.block.loader.BlockDefinitionProperties;
import snownee.kiwi.customization.block.loader.ConfiguredBlockTemplate;
import snownee.kiwi.customization.block.loader.KBlockComponents;
import snownee.kiwi.customization.block.loader.KBlockTemplate;
import snownee.kiwi.customization.shape.BlockShapeType;
import snownee.kiwi.customization.shape.ChoicesShape;
import snownee.kiwi.customization.shape.ConfiguringShape;
import snownee.kiwi.customization.shape.DirectionalShape;
import snownee.kiwi.customization.shape.HorizontalShape;
import snownee.kiwi.customization.shape.MouldingShape;
import snownee.kiwi.customization.shape.ShapeGenerator;
import snownee.kiwi.customization.shape.ShapeStorage;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.util.VanillaActions;
import snownee.kiwi.util.VoxelUtil;

public record KBlockDefinition(ConfiguredBlockTemplate template, BlockDefinitionProperties properties) {
    public KBlockDefinition(ConfiguredBlockTemplate template, BlockDefinitionProperties properties) {
        this.template = template;
        this.properties = template.template().properties().map(properties::merge).orElse(properties);
    }

    public static Codec<KBlockDefinition> codec(Map<class_2960, KBlockTemplate> templates, BlockFundamentals.CodecCreationContext context) {
        KBlockTemplate defaultTemplate = templates.get(class_2960.method_60656((String)"block"));
        Preconditions.checkNotNull((Object)defaultTemplate);
        ConfiguredBlockTemplate defaultConfiguredTemplate = new ConfiguredBlockTemplate(defaultTemplate);
        return RecordCodecBuilder.create(instance -> instance.group((App)ConfiguredBlockTemplate.codec(templates).optionalFieldOf("template", (Object)defaultConfiguredTemplate).forGetter(KBlockDefinition::template), (App)BlockDefinitionProperties.mapCodec(context).forGetter(KBlockDefinition::properties)).apply((Applicative)instance, KBlockDefinition::new));
    }

    public KBlockSettings.Builder createSettings(class_2960 id, ShapeStorage shapes) {
        BlockDefinitionProperties.PartialVanillaProperties vanilla = this.properties.vanillaProperties();
        KBlockSettings.Builder builder = vanilla.copy().isEmpty() ? KBlockSettings.builder() : KBlockSettings.copyProperties((class_2248)class_7923.field_41175.method_31140(vanilla.copy().get()));
        this.properties.glassType().ifPresent(builder::glassType);
        builder.configure($ -> {
            vanilla.lightEmission().ifPresent(i -> $.method_9631($$ -> i));
            vanilla.pushReaction().ifPresent(arg_0 -> ((class_4970.class_2251)$).method_50012(arg_0));
            vanilla.emissiveRendering().ifPresent(arg_0 -> ((class_4970.class_2251)$).method_26249(arg_0));
            vanilla.hasPostProcess().ifPresent(arg_0 -> ((class_4970.class_2251)$).method_26247(arg_0));
            vanilla.isRedstoneConductor().ifPresent(arg_0 -> ((class_4970.class_2251)$).method_26236(arg_0));
            vanilla.isSuffocating().ifPresent(arg_0 -> ((class_4970.class_2251)$).method_26243(arg_0));
            vanilla.isViewBlocking().ifPresent(arg_0 -> ((class_4970.class_2251)$).method_26245(arg_0));
            vanilla.isValidSpawn().ifPresent(arg_0 -> ((class_4970.class_2251)$).method_26235(arg_0));
            vanilla.offsetType().ifPresent(arg_0 -> ((class_4970.class_2251)$).method_49229(arg_0));
            vanilla.legacySolid().ifPresent(bl -> {
                if (bl.booleanValue()) {
                    $.method_51369();
                } else {
                    $.method_51370();
                }
            });
            if (vanilla.noCollision().orElse(false).booleanValue()) {
                $.method_9634();
            }
            if (vanilla.noOcclusion().orElse(this.properties.glassType().isPresent()).booleanValue()) {
                $.method_22488();
            }
            if (vanilla.isRandomlyTicking().orElse(false).booleanValue()) {
                $.method_9640();
            }
            if (vanilla.dynamicShape().orElse(false).booleanValue()) {
                $.method_9624();
            }
            if (vanilla.replaceable().orElse(false).booleanValue()) {
                $.method_51371();
            }
        });
        this.properties.material().ifPresent(mat -> builder.configure($ -> {
            $.method_9629(mat.destroyTime(), mat.explosionResistance());
            $.method_9626(mat.soundType());
            $.method_51368(mat.instrument());
            $.method_31710(mat.defaultMapColor());
            if (mat.ignitedByLava()) {
                $.method_50013();
            }
            if (mat.requiresCorrectToolForDrops()) {
                $.method_29292();
            }
        }));
        if (this.properties.material().isEmpty()) {
            builder.configure($ -> $.method_9629(2.0f, 3.0f));
        }
        this.properties.canSurviveHandler().ifPresent(builder::canSurviveHandler);
        for (Either<KBlockComponent, String> component : this.properties.components()) {
            if (component.left().isPresent()) {
                builder.component((KBlockComponent)component.left().get());
                continue;
            }
            String s = (String)component.right().orElseThrow();
            boolean remove = s.startsWith("-");
            if (remove) {
                s = s.substring(1);
            }
            KBlockComponent.Type type = (KBlockComponent.Type)CustomizationRegistries.BLOCK_COMPONENT.method_10223(class_2960.method_60654((String)s));
            Preconditions.checkNotNull((Object)type, (String)"Unknown component type %s", (Object)s);
            if (remove) {
                builder.removeComponent(type);
                continue;
            }
            builder.component(KBlockComponents.getSimpleInstance(type));
        }
        if (!Platform.isDataGen()) {
            this.deriveAndSetShape(shapes, builder, BlockShapeType.MAIN, this.properties.shape());
            this.deriveAndSetShape(shapes, builder, BlockShapeType.COLLISION, this.properties.collisionShape());
            this.deriveAndSetShape(shapes, builder, BlockShapeType.INTERACTION, this.properties.interactionShape());
        }
        return builder;
    }

    public class_2248 createBlock(class_2960 id, ShapeStorage shapes) {
        KBlockSettings.Builder builder = this.createSettings(id, shapes);
        class_2248 block = this.template.template().createBlock(id, builder.get(), this.template.json());
        KBlockDefinition.setConfiguringShape(block, shapes);
        this.properties.material().ifPresent(mat -> VanillaActions.setFireInfo(block, mat.igniteOdds(), mat.burnOdds()));
        KBlockSettings settings = Objects.requireNonNull(KBlockSettings.of(block));
        BlockBehaviorRegistry behaviorRegistry = BlockBehaviorRegistry.getInstance();
        for (KBlockComponent component : settings.components.values()) {
            behaviorRegistry.setContext(block);
            component.addBehaviors(behaviorRegistry);
        }
        behaviorRegistry.setContext(null);
        return block;
    }

    public static void setConfiguringShape(class_2248 block, ShapeStorage shapes) {
        KBlockSettings settings = KBlockSettings.of(block);
        if (settings == null) {
            return;
        }
        for (BlockShapeType shapeType : BlockShapeType.VALUES) {
            ConfiguringShape shape = settings.removeIfPossible(shapeType);
            if (shape == null) continue;
            shape.configure(block, shapeType, shapes);
        }
    }

    private void deriveAndSetShape(ShapeStorage shapes, KBlockSettings.Builder builder, BlockShapeType type, Optional<class_2960> shapeId) {
        if (shapeId.isEmpty()) {
            return;
        }
        ShapeGenerator shape = shapes.get(shapeId.get());
        if (shape == null) {
            Kiwi.LOGGER.warn("Shape {} is not registered", (Object)shapeId.get());
            return;
        }
        if (shape.getClass() != ShapeGenerator.Unit.class) {
            builder.shape(type, shape);
            return;
        }
        if (builder.hasComponent(KBlockComponents.HORIZONTAL.getOrCreate())) {
            shape = shapes.transform(shape, KBlockComponents.HORIZONTAL.getOrCreate(), HorizontalShape::create);
        } else if (builder.hasComponent(KBlockComponents.DIRECTIONAL.getOrCreate())) {
            shape = shapes.transform(shape, KBlockComponents.DIRECTIONAL.getOrCreate(), $ -> DirectionalShape.create($, "facing"));
        } else if (builder.hasComponent(KBlockComponents.MOULDING.getOrCreate())) {
            shape = shapes.transform(shape, KBlockComponents.MOULDING.getOrCreate(), MouldingShape::create);
        } else if (builder.hasComponent(KBlockComponents.FRONT_AND_TOP.getOrCreate())) {
            shape = shapes.transform(shape, KBlockComponents.FRONT_AND_TOP.getOrCreate(), $ -> DirectionalShape.create($, "orientation"));
        } else if (builder.hasComponent(KBlockComponents.HORIZONTAL_AXIS.getOrCreate())) {
            shape = shapes.transform(shape, KBlockComponents.HORIZONTAL_AXIS.getOrCreate(), $ -> ChoicesShape.chooseOneProperty(class_2741.field_12529, Map.of(class_2350.class_2351.field_11048, $, class_2350.class_2351.field_11051, ShapeGenerator.unit(VoxelUtil.rotateHorizontal(ShapeGenerator.Unit.unboxOrThrow($), class_2350.field_11034)))));
        }
        builder.shape(type, shape);
    }
}

