/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.loader;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2349;
import net.minecraft.class_2473;
import net.minecraft.class_2508;
import net.minecraft.class_2510;
import net.minecraft.class_2551;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_7713;
import net.minecraft.class_7715;
import net.minecraft.class_7923;
import net.minecraft.class_8177;
import net.minecraft.class_8805;
import net.minecraft.class_8812;
import org.apache.commons.lang3.NotImplementedException;
import snownee.kiwi.customization.block.BasicBlock;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.block.loader.KBlockComponents;
import snownee.kiwi.customization.duck.KBlockProperties;
import snownee.kiwi.util.codec.CustomizationCodecs;

public class BlockCodecs {
    private static final Map<class_2960, MapCodec<class_2248>> CODECS = Maps.newHashMap();
    public static final String BLOCK_PROPERTIES_KEY = "properties";
    public static final Function<class_4970.class_2251, class_2248> SIMPLE_BLOCK_FACTORY = properties -> {
        KBlockSettings settings = ((KBlockProperties)properties).kiwi$getSettings();
        if (settings != null && settings.hasComponent(KBlockComponents.WATER_LOGGABLE.getOrCreate())) {
            return new BasicBlock((class_4970.class_2251)properties);
        }
        return new class_2248(properties);
    };
    public static final MapCodec<class_2248> BLOCK = class_2248.method_54094(SIMPLE_BLOCK_FACTORY);
    public static final MapCodec<class_2510> STAIR = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2680.field_24734.optionalFieldOf("base_state", (Object)class_2246.field_10124.method_9564()).forGetter(block -> {
        throw new UnsupportedOperationException();
    }), (App)class_2248.method_54096()).apply((Applicative)instance, class_2510::new));
    public static final MapCodec<class_2349> FENCE_GATE = BlockCodecs.woodTyped(class_2349::new);
    public static final MapCodec<class_8812> COLORED_FALLING = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_8805.field_46234.optionalFieldOf("falling_dust_color", (Object)new class_8805(14406560)).forGetter($ -> new class_8805(14406560)), (App)class_2248.method_54096()).apply((Applicative)instance, class_8812::new));
    public static final MapCodec<class_2269> BUTTON = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_8177.field_46534.fieldOf("block_set_type").forGetter(BlockCodecs::notImplemented), (App)Codec.intRange((int)1, (int)1024).optionalFieldOf("ticks_to_stay_pressed").forGetter(BlockCodecs::notImplemented), (App)class_2248.method_54096()).apply((Applicative)instance, (blockSetType, ticksToStayPressed, properties) -> new class_2269(blockSetType, ticksToStayPressed.orElse(blockSetType.comp_1471() ? 30 : 20).intValue(), properties)));
    public static final MapCodec<class_2551> WALL_SIGN = BlockCodecs.woodTyped(class_2551::new);
    public static final MapCodec<class_2508> STANDING_SIGN = BlockCodecs.woodTyped(class_2508::new);
    public static final MapCodec<class_7715> WALL_HANGING_SIGN = BlockCodecs.woodTyped(class_7715::new);
    public static final MapCodec<class_7713> CEILING_HANGING_SIGN = BlockCodecs.woodTyped(class_7713::new);
    public static final MapCodec<class_2473> SAPLING = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CustomizationCodecs.TREE_GROWER.fieldOf("tree").forGetter(BlockCodecs::notImplemented), (App)class_2248.method_54096()).apply((Applicative)instance, class_2473::new));

    public static void register(String key, MapCodec<? extends class_2248> codec) {
        BlockCodecs.register(class_2960.method_60656((String)key), codec);
    }

    public static void register(class_2960 key, MapCodec<? extends class_2248> codec) {
        CODECS.put(key, codec);
    }

    public static MapCodec<class_2248> get(class_2960 key) {
        MapCodec<class_2248> codec = CODECS.get(key);
        if (codec != null) {
            return codec;
        }
        return (MapCodec)class_7923.field_46591.method_10223(key);
    }

    public static <O, A> A notImplemented(O block) {
        throw new NotImplementedException();
    }

    public static <T extends class_2248> MapCodec<T> woodTyped(BiFunction<class_4719, class_4970.class_2251, T> factory) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_4719.field_46535.optionalFieldOf("wood_type", (Object)class_4719.field_21676).forGetter($ -> class_4719.field_21676), (App)class_2248.method_54096()).apply((Applicative)instance, factory));
    }

    static {
        BlockCodecs.register("block", BLOCK);
        BlockCodecs.register("stair", STAIR);
        BlockCodecs.register("fence_gate", FENCE_GATE);
        BlockCodecs.register("colored_falling", COLORED_FALLING);
        BlockCodecs.register("button", BUTTON);
        BlockCodecs.register("wall_sign", WALL_SIGN);
        BlockCodecs.register("standing_sign", STANDING_SIGN);
        BlockCodecs.register("wall_hanging_sign", WALL_HANGING_SIGN);
        BlockCodecs.register("ceiling_hanging_sign", CEILING_HANGING_SIGN);
        BlockCodecs.register("sapling", SAPLING);
    }
}

