/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.family;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3975;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import snownee.kiwi.customization.block.family.BlockFamilies;
import snownee.kiwi.customization.block.family.BlockFamily;
import snownee.kiwi.util.KHolder;

public class StonecutterRecipeMaker {
    private static final Cache<class_1792, List<class_8786<class_3975>>> EXCHANGE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(Duration.of(1L, ChronoUnit.MINUTES)).build();
    private static final Cache<class_1792, List<class_8786<class_3975>>> SOURCE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(Duration.of(1L, ChronoUnit.MINUTES)).build();

    public static <C extends class_9695, T extends class_1860<C>> List<class_8786<T>> appendRecipesFor(List<class_8786<T>> recipes, C input) {
        class_1799 itemStack = input.method_59984(0);
        if (itemStack.method_7960()) {
            return recipes;
        }
        class_1792 item = itemStack.method_7909();
        List exchangeRecipes = List.of();
        try {
            Collection<KHolder<BlockFamily>> families = BlockFamilies.find(item);
            if (!families.isEmpty()) {
                exchangeRecipes = (List)EXCHANGE_CACHE.get((Object)item, () -> {
                    ArrayList list = null;
                    for (KHolder family : families) {
                        if (!((BlockFamily)family.value()).stonecutterExchange()) continue;
                        if (list == null) {
                            list = Lists.newArrayList();
                        }
                        list.addAll(StonecutterRecipeMaker.makeRecipes("exchange", family));
                    }
                    return list == null ? List.of() : list;
                });
            }
        }
        catch (ExecutionException families) {
            // empty catch block
        }
        List sourceRecipes = List.of();
        try {
            Collection<KHolder<BlockFamily>> families = BlockFamilies.findByStonecutterSource(item);
            if (!families.isEmpty()) {
                sourceRecipes = (List)SOURCE_CACHE.get((Object)item, () -> {
                    ArrayList list = Lists.newArrayList();
                    for (KHolder family : families) {
                        list.addAll(StonecutterRecipeMaker.makeRecipes("to", family));
                    }
                    return list;
                });
            }
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        if (exchangeRecipes.isEmpty() && sourceRecipes.isEmpty()) {
            return recipes;
        }
        return Streams.concat((Stream[])new Stream[]{recipes.stream(), exchangeRecipes.stream(), sourceRecipes.stream()}).map(r -> r).collect(Collectors.toCollection(ArrayList::new));
    }

    public static List<class_8786<class_3975>> makeRecipes(String type, KHolder<BlockFamily> family) {
        class_1856 input = switch (type) {
            case "exchange" -> family.value().ingredient();
            case "exchange_in_viewer" -> family.value().ingredientInViewer();
            case "to" -> family.value().stonecutterSourceIngredient();
            default -> throw new IllegalArgumentException();
        };
        boolean exchangeInViewer = "exchange_in_viewer".equals(type);
        class_2960 prefix = family.key().method_45136("/stonecutter/%s/%s".formatted(family.key().method_12832(), exchangeInViewer ? "exchange" : type));
        return family.value().items().map(item -> {
            int count;
            if ("to".equals(type)) {
                count = ((BlockFamily)family.value()).stonecutterSourceMultiplier();
            } else {
                count = class_3532.method_15375((float)(1.0f / BlockFamilies.getConvertRatio(item)));
                if (count < 1) {
                    return null;
                }
            }
            class_1799 itemStack = new class_1799((class_1935)item, count);
            if (exchangeInViewer && !((BlockFamily)family.value()).exchangeInputsInViewer().isEmpty() && ((BlockFamily)family.value()).ingredientInViewer().method_8093(itemStack)) {
                return null;
            }
            class_2960 itemKey = class_7923.field_41178.method_10221(item);
            class_2960 recipeId = prefix.method_48331("/%s/%s".formatted(itemKey.method_12836(), itemKey.method_12832()));
            class_3975 recipe = new class_3975(prefix.toString(), input, itemStack);
            return new class_8786(recipeId, (class_1860)recipe);
        }).filter(Objects::nonNull).toList();
    }

    public static void invalidateCache() {
        EXCHANGE_CACHE.invalidateAll();
        SOURCE_CACHE.invalidateAll();
    }
}

