/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.behavior;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1804;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2244;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2561;
import net.minecraft.class_2577;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_5134;
import net.minecraft.class_5575;
import net.minecraft.class_8113;
import net.minecraft.class_9817;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.customization.CustomFeatureTags;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.block.KBlockUtils;
import snownee.kiwi.customization.block.behavior.KSitCommonConfig;
import snownee.kiwi.customization.block.component.KBlockComponent;
import snownee.kiwi.mixin.customization.sit.EntityAccess;

public class SitManager {
    public static final class_2561 ENTITY_NAME = class_2561.method_43470((String)"Seat from Kiwi");

    public static void tick(class_8113.class_8115 display) {
        if (display.field_6012 < 7) {
            return;
        }
        if (!display.method_5782()) {
            display.method_31472();
        }
        class_2338 pos = class_2338.method_49637((double)display.method_23317(), (double)display.method_23318(), (double)display.method_23321());
        class_2680 blockState = display.method_37908().method_8320(pos);
        if (!blockState.method_27852(display.method_48884().method_26204())) {
            display.method_31472();
        }
    }

    public static boolean sit(class_1657 player, class_3965 hitResult) {
        class_2338 pos;
        if (!(!KSitCommonConfig.requireEmptyHand || player.method_6047().method_7960() && player.method_6079().method_7960())) {
            return false;
        }
        if (!KSitCommonConfig.allowClickBlockBottomToSit && hitResult.method_17780() == class_2350.field_11033) {
            return false;
        }
        if (player.method_21823()) {
            return false;
        }
        class_1937 level = player.method_37908();
        class_2680 blockState = level.method_8320(pos = hitResult.method_17777());
        if (!blockState.method_26164(CustomFeatureTags.SITTABLE)) {
            return false;
        }
        class_2248 block = blockState.method_26204();
        if (block instanceof class_2244) {
            class_3222 serverPlayer;
            if (((Boolean)blockState.method_11654((class_2769)class_2244.field_9968)).booleanValue() || !class_2244.method_27352((class_1937)level)) {
                return false;
            }
            class_2350 direction = (class_2350)blockState.method_11654((class_2769)class_2244.field_11177);
            if (player instanceof class_3222 && (serverPlayer = (class_3222)player).method_26285(pos, direction)) {
                return false;
            }
        } else if (player.method_33571().method_1025(hitResult.method_17784()) > class_3532.method_33723((double)(player.method_45325(class_5134.field_47758) * (double)KSitCommonConfig.sitActionReachDistanceRatio))) {
            return false;
        }
        if (!player.method_6047().method_7960() && player.method_6047().method_31574(block.method_8389())) {
            return false;
        }
        if (!KSitCommonConfig.sitOnStairs && block instanceof class_2510) {
            return false;
        }
        if (!KSitCommonConfig.sitOnSlab && block instanceof class_2482) {
            return false;
        }
        if (!KSitCommonConfig.sitOnCarpet && block instanceof class_2577) {
            return false;
        }
        if (!KSitCommonConfig.sitOnBed && block instanceof class_2244) {
            return false;
        }
        if (!level.method_18023((class_5575)class_1299.field_42460, new class_238(pos).method_1012(0.0, 1.0, 0.0), SitManager::isSeatEntity).isEmpty()) {
            return false;
        }
        if (!level.field_9236) {
            class_8113.class_8115 display = new class_8113.class_8115(class_1299.field_42460, level);
            display.method_5665(ENTITY_NAME);
            display.method_48883(blockState);
            class_265 shape = blockState.method_26172((class_1922)level, pos, class_3726.method_16195((class_1297)player));
            class_243 seatPos = null;
            class_2350 facing = SitManager.guessBlockFacing(blockState, player);
            if (!shape.method_1110()) {
                class_243 traceEnd;
                class_243 traceStart;
                class_3965 hit;
                class_238 bounds = shape.method_1107();
                double x = (bounds.field_1323 + bounds.field_1320) / 2.0;
                double y = bounds.field_1320 + 0.1;
                double z = (bounds.field_1321 + bounds.field_1324) / 2.0;
                if (facing != null) {
                    x += (double)facing.method_10148() * 0.1;
                    z += (double)facing.method_10165() * 0.1;
                }
                if ((hit = shape.method_1092(traceStart = new class_243((double)pos.method_10263() + x, (double)pos.method_10264() + y, (double)pos.method_10260() + z), traceEnd = traceStart.method_1031(0.0, -2.0, 0.0), pos)) != null && hit.method_17783() == class_239.class_240.field_1332) {
                    seatPos = hit.method_17784();
                }
            }
            if (facing == null) {
                display.method_36456(player.method_36454());
            } else {
                float yRot = facing.method_10144();
                display.method_36456(yRot);
                display.method_5875(true);
            }
            if (seatPos == null) {
                seatPos = class_243.method_24953((class_2382)pos);
            }
            double clampedY = class_3532.method_15350((double)seatPos.field_1351, (double)pos.method_10264(), (double)((double)pos.method_10264() + 0.999));
            display.method_5814(seatPos.field_1352, clampedY, seatPos.field_1350);
            class_1657 rider = player;
            if (KSitCommonConfig.makeLeashedMobSit) {
                List list = class_1804.method_61166((class_1937)level, (class_2338)player.method_24515(), leashable -> leashable.method_60952() == player);
                double dist = Double.MAX_VALUE;
                for (class_9817 leashable2 : list) {
                    class_1308 mob;
                    if (!(leashable2 instanceof class_1308) || (mob = (class_1308)leashable2).method_5987() || !((EntityAccess)mob).callCanRide((class_1297)display)) continue;
                    double d = mob.method_5858((class_1297)player);
                    if (rider != player && !(d < dist)) continue;
                    rider = mob;
                    dist = d;
                }
            }
            if (level.method_8649((class_1297)display)) {
                rider.method_36456(display.method_36454());
                rider.method_5873((class_1297)display, true);
                if (rider != player) {
                    ((class_9817)rider).method_5932(true, true);
                }
            }
        }
        return true;
    }

    @Nullable
    public static class_2350 guessBlockFacing(class_2680 blockState, @Nullable class_1657 player) {
        class_2350 direction;
        class_2350.class_2351 axis;
        if (blockState.method_26164(class_3481.field_16443)) {
            return null;
        }
        KBlockSettings settings = KBlockSettings.of(blockState.method_26204());
        if (settings != null) {
            for (KBlockComponent component : settings.components.values()) {
                class_2350 facing = component.getHorizontalFacing(blockState);
                if (facing == null) continue;
                return facing;
            }
        }
        boolean oppose = false;
        try {
            String shape = KBlockUtils.getValueString(blockState, "shape");
            if (!"straight".equals(shape)) {
                return null;
            }
            oppose = blockState.method_26204() instanceof class_2510;
        }
        catch (Throwable shape) {
            // empty catch block
        }
        if (blockState.method_28498((class_2769)class_2741.field_12481)) {
            class_2350 direction2 = (class_2350)blockState.method_11654((class_2769)class_2741.field_12481);
            return oppose ? direction2.method_10153() : direction2;
        }
        if (player != null && blockState.method_28498((class_2769)class_2741.field_12529) && (axis = (class_2350.class_2351)blockState.method_11654((class_2769)class_2741.field_12529)).method_10176(direction = player.method_5735())) {
            return direction;
        }
        return null;
    }

    public static boolean isSeatEntity(@Nullable class_1297 entity) {
        if (entity == null || entity.method_5864() != class_1299.field_42460) {
            return false;
        }
        class_2561 customName = entity.method_5797();
        return customName != null && Objects.equals(customName.getString(), ENTITY_NAME.getString());
    }

    public static void clampRotation(class_1657 player, class_1297 seat) {
        if (!seat.method_5740()) {
            return;
        }
        float seatRot = class_3532.method_15393((float)seat.method_36454());
        float f = class_3532.method_15393((float)(player.method_36454() - seatRot));
        float f1 = class_3532.method_15363((float)f, (float)-105.0f, (float)105.0f);
        player.field_5982 += f1 - f;
        player.method_36456(player.method_36454() + f1 - f);
        player.method_5847(player.method_36454());
        player.method_5636(seatRot);
        f = class_3532.method_15393((float)player.method_36455());
        f1 = Math.max(f, -45.0f);
        player.method_36457(f1);
    }

    public static class_243 dismount(class_1297 display, class_1309 passenger) {
        class_2350 direction = display.method_5740() ? display.method_5735() : passenger.method_5735();
        class_2338 pos = class_2338.method_49637((double)display.method_23317(), (double)display.method_23318(), (double)display.method_23321());
        Optional vec3 = class_2244.method_9484((class_1299)passenger.method_5864(), (class_1941)passenger.method_37908(), (class_2338)pos, (class_2350)direction, (float)passenger.method_36454());
        return vec3.orElseGet(() -> class_243.method_24955((class_2382)pos.method_10084()));
    }
}

