/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3294;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_6860;
import net.minecraft.class_7084;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import snownee.kiwi.Kiwi;

public class KiwiPackResourceManager
implements class_6860 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<String, class_3294> namespacedManagers;
    private final List<class_3262> packs;

    public KiwiPackResourceManager(List<class_3262> packs) {
        this.packs = packs.stream().filter(pack -> {
            if (pack.method_14406(class_3264.field_14188) == null) {
                Kiwi.LOGGER.error("Pack {}({}) has null namespaces", (Object)pack.method_14409(), (Object)pack.getClass());
                return false;
            }
            return true;
        }).toList();
        packs = this.packs;
        HashMap<String, class_3294> map = new HashMap<String, class_3294>();
        List list = packs.stream().flatMap(pack -> pack.method_14406(class_3264.field_14188).stream()).distinct().toList();
        for (class_3262 packresources : packs) {
            class_7084 resourcefiltersection = this.getPackFilterSection(packresources);
            Set set = packresources.method_14406(class_3264.field_14188);
            Predicate<class_2960> predicate = resourcefiltersection != null ? p_215474_ -> resourcefiltersection.method_41281(p_215474_.method_12832()) : null;
            for (String s : list) {
                boolean flag1;
                boolean flag = set.contains(s);
                boolean bl = flag1 = resourcefiltersection != null && resourcefiltersection.method_41279(s);
                if (!flag && !flag1) continue;
                class_3294 fallbackresourcemanager = map.computeIfAbsent(s, s1 -> new class_3294(class_3264.field_14188, s1));
                if (flag && flag1) {
                    fallbackresourcemanager.method_41256(packresources, predicate);
                    continue;
                }
                if (flag) {
                    fallbackresourcemanager.method_24233(packresources);
                    continue;
                }
                fallbackresourcemanager.method_41261(packresources.method_14409(), predicate);
            }
        }
        this.namespacedManagers = map;
    }

    @Nullable
    private class_7084 getPackFilterSection(class_3262 p_215468_) {
        try {
            return (class_7084)p_215468_.method_14407((class_3270)class_7084.field_40055);
        }
        catch (IOException ioexception) {
            LOGGER.error("Failed to get filter section from pack {}", (Object)p_215468_.method_14409());
            return null;
        }
    }

    public Set<String> method_14487() {
        return this.namespacedManagers.keySet();
    }

    public Optional<class_3298> method_14486(class_2960 p_215482_) {
        class_3300 resourcemanager = (class_3300)this.namespacedManagers.get(p_215482_.method_12836());
        return resourcemanager != null ? resourcemanager.method_14486(p_215482_) : Optional.empty();
    }

    public List<class_3298> method_14489(class_2960 p_215466_) {
        class_3300 resourcemanager = (class_3300)this.namespacedManagers.get(p_215466_.method_12836());
        return resourcemanager != null ? resourcemanager.method_14489(p_215466_) : List.of();
    }

    public Map<class_2960, class_3298> method_14488(String p_215476_, Predicate<class_2960> p_215477_) {
        KiwiPackResourceManager.checkTrailingDirectoryPath(p_215476_);
        TreeMap<class_2960, class_3298> map = new TreeMap<class_2960, class_3298>();
        for (class_3294 fallbackresourcemanager : this.namespacedManagers.values()) {
            map.putAll(fallbackresourcemanager.method_14488(p_215476_, p_215477_));
        }
        return map;
    }

    public Map<class_2960, List<class_3298>> method_41265(String p_215479_, Predicate<class_2960> p_215480_) {
        KiwiPackResourceManager.checkTrailingDirectoryPath(p_215479_);
        TreeMap<class_2960, List<class_3298>> map = new TreeMap<class_2960, List<class_3298>>();
        for (class_3294 fallbackresourcemanager : this.namespacedManagers.values()) {
            map.putAll(fallbackresourcemanager.method_41265(p_215479_, p_215480_));
        }
        return map;
    }

    private static void checkTrailingDirectoryPath(String p_249608_) {
        if (p_249608_.endsWith("/")) {
            throw new IllegalArgumentException("Trailing slash in path " + p_249608_);
        }
    }

    public Stream<class_3262> method_29213() {
        return this.packs.stream();
    }

    public void close() {
        this.packs.forEach(class_3262::close);
    }
}

