/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBlockTags;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_247;
import net.minecraft.class_2506;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3283;
import net.minecraft.class_3285;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_5352;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_8580;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.Kiwi;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.LoadingContext;
import snownee.kiwi.customization.CustomizationClient;
import snownee.kiwi.customization.CustomizationMetadata;
import snownee.kiwi.customization.CustomizationRegistries;
import snownee.kiwi.customization.CustomizationServiceFinder;
import snownee.kiwi.customization.KiwiPackResourceManager;
import snownee.kiwi.customization.block.BlockFundamentals;
import snownee.kiwi.customization.block.GlassType;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.block.behavior.BlockBehaviorRegistry;
import snownee.kiwi.customization.block.behavior.SitManager;
import snownee.kiwi.customization.block.component.KBlockComponent;
import snownee.kiwi.customization.block.family.BlockFamilies;
import snownee.kiwi.customization.block.loader.KBlockDefinition;
import snownee.kiwi.customization.block.loader.KBlockTemplate;
import snownee.kiwi.customization.block.soundtype.DeferredSoundType;
import snownee.kiwi.customization.block.soundtype.SoundTypes;
import snownee.kiwi.customization.block.tier.KiwiTiers;
import snownee.kiwi.customization.block.tier.SimpleTier;
import snownee.kiwi.customization.builder.BuilderRule;
import snownee.kiwi.customization.builder.BuilderRules;
import snownee.kiwi.customization.item.ItemFundamentals;
import snownee.kiwi.customization.item.loader.KCreativeTab;
import snownee.kiwi.customization.item.loader.KItemTemplate;
import snownee.kiwi.customization.placement.PlacementSystem;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.util.ClientProxy;
import snownee.kiwi.util.resource.OneTimeLoader;
import snownee.kiwi.util.resource.RequiredFolderRepositorySource;

public final class CustomizationHooks {
    private static final Set<String> blockNamespaces = Sets.newLinkedHashSet();
    private static final Set<String> lenientBETypeNamespaces = Sets.newHashSet();
    private static boolean enabled = true;
    public static boolean kswitch = Platform.isModLoaded("kswitch") || !Platform.isProduction();
    @Nullable
    private static GlassType clearGlassType;
    private static final int CACHE_SIZE = 512;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<class_2248.class_2249>> OCCLUSION_CACHE;

    private CustomizationHooks() {
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static boolean skipGlassRendering(class_2680 pState, class_2680 pAdjacentBlockState, class_2350 pDirection) {
        if (KBlockSettings.of(pState.method_26204()) == null && KBlockSettings.of(pAdjacentBlockState.method_26204()) == null) {
            return false;
        }
        GlassType glassType = CustomizationHooks.getGlassType(pState);
        if (glassType == null || !glassType.skipRendering()) {
            return false;
        }
        if (!pState.method_27852(pAdjacentBlockState.method_26204()) && glassType != CustomizationHooks.getGlassType(pAdjacentBlockState)) {
            return false;
        }
        class_2248.class_2249 key = new class_2248.class_2249(pState, pAdjacentBlockState, pDirection);
        Object2ByteLinkedOpenHashMap<class_2248.class_2249> map = OCCLUSION_CACHE.get();
        byte b0 = map.getAndMoveToFirst((Object)key);
        if (b0 != 127) {
            return b0 == 0;
        }
        class_265 shape1 = KBlockSettings.getGlassFaceShape(pState, pDirection);
        if (shape1.method_1110()) {
            return true;
        }
        class_265 shape2 = KBlockSettings.getGlassFaceShape(pAdjacentBlockState, pDirection.method_10153());
        boolean flag = class_259.method_1074((class_265)shape1, (class_265)shape2, (class_247)class_247.field_16886);
        if (map.size() == 512) {
            map.removeLastByte();
        }
        map.putAndMoveToFirst((Object)key, (byte)(flag ? 1 : 0));
        return !flag;
    }

    @Nullable
    public static GlassType getGlassType(class_2680 blockState) {
        KBlockSettings settings = KBlockSettings.of(blockState.method_26204());
        if (settings != null && settings.glassType != null) {
            return settings.glassType;
        }
        if (CustomizationHooks.isColorlessGlass(blockState)) {
            return clearGlassType;
        }
        return null;
    }

    public static void init() {
        enabled = CustomizationServiceFinder.shouldEnable(FabricLoader.getInstance().getAllMods());
        if (!CustomizationHooks.isEnabled()) {
            return;
        }
        Kiwi.LOGGER.info("Kiwi Customization is enabled");
        CustomizationRegistries.BLOCK_COMPONENT = FabricRegistryBuilder.createSimple(CustomizationRegistries.BLOCK_COMPONENT_KEY).buildAndRegister();
        Kiwi.registerRegistry(CustomizationRegistries.BLOCK_COMPONENT_KEY, KBlockComponent.Type.class);
        CustomizationRegistries.BLOCK_TEMPLATE = FabricRegistryBuilder.createSimple(CustomizationRegistries.BLOCK_TEMPLATE_KEY).buildAndRegister();
        Kiwi.registerRegistry(CustomizationRegistries.BLOCK_TEMPLATE_KEY, KBlockTemplate.Type.class);
        CustomizationRegistries.ITEM_TEMPLATE = FabricRegistryBuilder.createSimple(CustomizationRegistries.ITEM_TEMPLATE_KEY).buildAndRegister();
        Kiwi.registerRegistry(CustomizationRegistries.ITEM_TEMPLATE_KEY, KItemTemplate.Type.class);
        CustomizationRegistries.BUILDER_RULE = FabricRegistryBuilder.createSimple(CustomizationRegistries.BUILDER_RULE_KEY).buildAndRegister();
        Kiwi.registerRegistry(CustomizationRegistries.BUILDER_RULE_KEY, BuilderRule.Type.class);
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, entity) -> {
            if (PlacementSystem.isDebugEnabled(player)) {
                PlacementSystem.removeDebugBlocks(world, pos);
            }
        });
        UseBlockCallback.EVENT.register((player, level, hand, hitResult) -> BlockBehaviorRegistry.getInstance().onUseBlock(player, level, hand, hitResult));
        UseBlockCallback.EVENT.register((player, level, hand, hitResult) -> {
            if (hand == class_1268.field_5808 && SitManager.sit(player, hitResult)) {
                return class_1269.method_29236((boolean)level.field_9236);
            }
            return class_1269.field_5811;
        });
        CommonLifecycleEvents.TAGS_LOADED.register((registryAccess, client) -> BlockFamilies.reloadTags());
        if (Platform.isPhysicalClient()) {
            CustomizationClient.init();
        }
    }

    public static void initLoader() {
        class_3300 resourceManager = CustomizationHooks.collectKiwiPacks();
        OneTimeLoader.Context context = new OneTimeLoader.Context();
        Map<String, CustomizationMetadata> metadataMap = CustomizationMetadata.loadMap(resourceManager, context);
        SoundTypes.refreshWithValues(OneTimeLoader.load(resourceManager, "kiwi/sound_type", DeferredSoundType.DIRECT_CODEC.codec(), context));
        BlockFundamentals blockFundamentals = BlockFundamentals.reload(resourceManager, context, true);
        clearGlassType = blockFundamentals.glassTypes().get(class_2960.method_60656((String)"clear"));
        blockNamespaces.clear();
        blockFundamentals.blocks().keySet().stream().map(class_2960::method_12836).forEach(blockNamespaces::add);
        lenientBETypeNamespaces.clear();
        lenientBETypeNamespaces.add("minecraft");
        lenientBETypeNamespaces.addAll(blockNamespaces);
        metadataMap.values().forEach(metadata -> lenientBETypeNamespaces.addAll(metadata.lenientBETypeNamespaces()));
        ArrayList blockIds = Lists.newArrayList();
        CustomizationMetadata.sortedForEach(metadataMap, "block", blockFundamentals.blocks(), (id, definition) -> {
            try {
                class_2248 block = definition.createBlock((class_2960)id, blockFundamentals.shapes());
                if (block == null) {
                    return;
                }
                class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)id, (Object)block);
                blockFundamentals.slotProviders().attachSlotsA(block, (KBlockDefinition)definition);
                blockFundamentals.placeChoices().attachChoicesA(block, (KBlockDefinition)definition);
                blockIds.add(id);
            }
            catch (Exception e) {
                Kiwi.LOGGER.error("Failed to create block %s".formatted(id), (Throwable)e);
            }
        });
        KiwiTiers.refreshWithValues(OneTimeLoader.load(resourceManager, "kiwi/tier", SimpleTier.DIRECT_CODEC.codec(), context));
        ItemFundamentals itemFundamentals = ItemFundamentals.reload(resourceManager, context, true);
        for (class_2960 blockId : blockIds) {
            if (itemFundamentals.items().containsKey(blockId)) continue;
            itemFundamentals.addDefaultBlockItem(blockId);
        }
        KItemTemplate none = itemFundamentals.templates().get(class_2960.method_60656((String)"none"));
        Preconditions.checkNotNull((Object)none, (Object)"Missing 'none' item definition");
        CustomizationMetadata.sortedForEach(metadataMap, "item", itemFundamentals.items(), (id, definition) -> {
            try {
                if (definition.template().template() == none) {
                    return;
                }
                class_1792 item = definition.createItem((class_2960)id);
                if (item == null) {
                    return;
                }
                class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)id, (Object)item);
            }
            catch (Exception e) {
                Kiwi.LOGGER.error("Failed to create item %s".formatted(id), (Throwable)e);
            }
        });
        blockFundamentals.slotProviders().attachSlotsB();
        blockFundamentals.placeChoices().attachChoicesB();
        blockFundamentals.slotLinks().finish();
        Map<class_2960, KCreativeTab> tabs = OneTimeLoader.load(resourceManager, "kiwi/creative_tab", KCreativeTab.CODEC, context);
        List<Map.Entry> newTabs = tabs.entrySet().stream().sorted(Comparator.comparingInt($ -> ((KCreativeTab)$.getValue()).order())).filter(entry -> {
            KCreativeTab value = (KCreativeTab)entry.getValue();
            if (value.insert().isPresent()) {
                CustomizationHooks.insertToTab(value);
                return false;
            }
            return true;
        }).toList();
        for (int i = 0; i < newTabs.size(); ++i) {
            Map.Entry entry2 = newTabs.get(i);
            class_2960 key = (class_2960)entry2.getKey();
            KCreativeTab value = (KCreativeTab)entry2.getValue();
            class_1761.class_7913 tab = AbstractModule.itemCategory(key.method_12836(), key.method_12832(), () -> class_7923.field_41178.method_31189(value.icon()).orElse(class_1802.field_8077).method_7854()).method_47317((params, output) -> output.method_45423(value.contents().stream().map(arg_0 -> ((class_7922)class_7923.field_41178).method_29107(arg_0)).filter(Objects::nonNull).map(class_1792::method_7854).toList()));
            class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)key, (Object)tab.method_47324());
        }
        if (Platform.isDataGen()) {
            BlockFamilies.reloadResources(resourceManager, context);
        }
        if (Platform.isPhysicalClient()) {
            CustomizationClient.afterRegister(itemFundamentals.items(), blockFundamentals.blocks(), new ClientProxy.Context(true));
        }
    }

    private static void insertToTab(KCreativeTab kCreativeTab) {
        if (!Platform.isPhysicalClient()) {
            return;
        }
        ItemGroupEvents.modifyEntriesEvent(kCreativeTab.insert().orElseThrow()).register(entries -> {
            for (class_5321<class_1792> content : kCreativeTab.contents()) {
                class_1792 item = (class_1792)class_7923.field_41178.method_29107(content);
                if (item == null) {
                    return;
                }
                entries.method_45421((class_1935)item);
            }
        });
    }

    public static class_3300 collectKiwiPacks() {
        CustomizationServiceFinder.PACK_DIRECTORY.toFile().mkdirs();
        RequiredFolderRepositorySource folderRepositorySource = new RequiredFolderRepositorySource(CustomizationServiceFinder.PACK_DIRECTORY, class_3264.field_14188, class_5352.field_25348, new class_8580($ -> true));
        class_3283 packRepository = new class_3283(new class_3285[]{folderRepositorySource});
        packRepository.method_14445();
        ArrayList selected = Lists.newArrayList((Iterable)packRepository.method_29206());
        packRepository.method_14447((Collection)selected);
        return new KiwiPackResourceManager(packRepository.method_29211());
    }

    public static Set<String> getBlockNamespaces() {
        return blockNamespaces;
    }

    public static Set<String> getLenientBETypeNamespaces() {
        return lenientBETypeNamespaces;
    }

    public static boolean isColorlessGlass(class_2680 blockState) {
        return blockState.method_26164(ConventionalBlockTags.GLASS_BLOCKS) && !(blockState.method_26204() instanceof class_2506);
    }

    public static GlassType clearGlassType() {
        return Objects.requireNonNull(clearGlassType);
    }

    @KiwiModule.LoadingCondition(value={"block_components", "block_templates", "item_templates", "builder_rules"})
    public static boolean shouldLoad(LoadingContext ctx) {
        return CustomizationHooks.isEnabled();
    }

    public static void frozen() {
        class_3300 resourceManager = CustomizationHooks.collectKiwiPacks();
        OneTimeLoader.Context context = new OneTimeLoader.Context();
        BlockFamilies.reloadResources(resourceManager, context);
        BuilderRules.reload(resourceManager, context);
    }

    static {
        OCCLUSION_CACHE = ThreadLocal.withInitial(() -> {
            Object2ByteLinkedOpenHashMap<class_2248.class_2249> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<class_2248.class_2249>(512, 0.25f){

                protected void rehash(int needed) {
                }
            };
            object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
            return object2bytelinkedopenhashmap;
        });
    }
}

