/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.Kiwi;
import snownee.kiwi.RenderLayerEnum;
import snownee.kiwi.customization.block.GlassType;
import snownee.kiwi.customization.block.behavior.SitManager;
import snownee.kiwi.customization.block.loader.BlockDefinitionProperties;
import snownee.kiwi.customization.block.loader.KBlockDefinition;
import snownee.kiwi.customization.builder.BuildersButton;
import snownee.kiwi.customization.builder.ConvertScreen;
import snownee.kiwi.customization.command.ExportBlocksCommand;
import snownee.kiwi.customization.command.ExportCreativeTabsCommand;
import snownee.kiwi.customization.command.ExportMappingsCommand;
import snownee.kiwi.customization.command.ExportShapesCommand;
import snownee.kiwi.customization.command.PrintFamiliesCommand;
import snownee.kiwi.customization.command.ReloadBlockSettingsCommand;
import snownee.kiwi.customization.command.ReloadFamiliesAndRulesCommand;
import snownee.kiwi.customization.command.ReloadSlotsCommand;
import snownee.kiwi.customization.item.loader.KItemDefinition;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.util.ClientProxy;
import snownee.kiwi.util.SmartKey;
import snownee.kiwi.util.client.ColorProviderUtil;

public final class CustomizationClient {
    @Nullable
    public static SmartKey buildersButtonKey;

    public static void init() {
        ClientTickEvents.START_CLIENT_TICK.register(client -> ConvertScreen.tickLingering());
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, env) -> {
            LiteralArgumentBuilder kiwi = class_2170.method_9247((String)"kiwi");
            LiteralArgumentBuilder customization = (LiteralArgumentBuilder)class_2170.method_9247((String)"customization").requires(source -> source.method_9259(2));
            LiteralArgumentBuilder export = class_2170.method_9247((String)"export");
            ExportBlocksCommand.register((LiteralArgumentBuilder<class_2168>)export);
            ExportShapesCommand.register((LiteralArgumentBuilder<class_2168>)export);
            ExportCreativeTabsCommand.register((LiteralArgumentBuilder<class_2168>)export);
            LiteralArgumentBuilder reload = class_2170.method_9247((String)"reload");
            ReloadSlotsCommand.register((LiteralArgumentBuilder<class_2168>)reload);
            ReloadBlockSettingsCommand.register((LiteralArgumentBuilder<class_2168>)reload);
            ReloadFamiliesAndRulesCommand.register((LiteralArgumentBuilder<class_2168>)reload);
            PrintFamiliesCommand.register((LiteralArgumentBuilder<class_2168>)customization);
            if (!Platform.isProduction()) {
                ExportMappingsCommand.register((LiteralArgumentBuilder<class_2168>)export);
            }
            dispatcher.register((LiteralArgumentBuilder)kiwi.then(((LiteralArgumentBuilder)customization.then((ArgumentBuilder)export)).then((ArgumentBuilder)reload)));
        });
        WorldRenderEvents.BLOCK_OUTLINE.register((worldRenderContext, blockOutlineContext) -> !BuildersButton.cancelRenderHighlight());
        WorldRenderEvents.START.register(context -> {
            class_746 player = class_310.method_1551().field_1724;
            if (player != null && SitManager.isSeatEntity(player.method_5854())) {
                SitManager.clampRotation((class_1657)player, player.method_5854());
            }
        });
    }

    public static void afterRegister(Map<class_2960, KItemDefinition> items, Map<class_2960, KBlockDefinition> blocks, ClientProxy.Context context) {
        buildersButtonKey = new SmartKey.Builder("key.kiwi.builders_button2", "key.categories.gameplay").onLongPress(BuildersButton::onLongPress).onShortPress(BuildersButton::onShortPress).build();
        KeyBindingHelper.registerKeyBinding((class_304)buildersButtonKey);
        ClientProxy.afterRegisterSmartKey(buildersButtonKey);
        HashMap blockColors = Maps.newHashMap();
        HashMap itemColors = Maps.newHashMap();
        ArrayList blocksToAdd = Lists.newArrayList();
        ArrayList itemsToAdd = Lists.newArrayList();
        HashSet addedItems = Sets.newHashSet();
        for (Map.Entry<class_2960, KItemDefinition> entry : items.entrySet()) {
            KItemDefinition definition = entry.getValue();
            if (definition.properties().colorProvider().isEmpty()) continue;
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(entry.getKey());
            class_1792 providerItem = (class_1792)class_7923.field_41178.method_10223(definition.properties().colorProvider().get());
            if (providerItem == class_1802.field_8162) {
                Kiwi.LOGGER.warn("Cannot find color provider item %s for item %s".formatted(definition.properties().colorProvider().get(), entry.getKey()));
                continue;
            }
            itemsToAdd.add(Pair.of((Object)item, (Object)itemColors.computeIfAbsent(providerItem, ColorProviderUtil::delegate)));
            addedItems.add(item);
        }
        for (Map.Entry<class_2960, Record> entry : blocks.entrySet()) {
            class_1792 item;
            BlockDefinitionProperties properties = ((KBlockDefinition)entry.getValue()).properties();
            if (context.loading()) {
                RenderLayerEnum renderType = properties.renderType().orElse(null);
                if (renderType == null) {
                    renderType = properties.glassType().map(GlassType::renderType).orElse(null);
                }
                if (renderType != null) {
                    class_2248 block = (class_2248)class_7923.field_41175.method_10223(entry.getKey());
                    BlockRenderLayerMap.INSTANCE.putBlock(block, (class_1921)renderType.value);
                }
            }
            if (properties.colorProvider().isEmpty()) continue;
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(entry.getKey());
            class_2248 providerBlock = (class_2248)class_7923.field_41175.method_10223(properties.colorProvider().get());
            if (providerBlock == class_2246.field_10124) {
                Kiwi.LOGGER.warn("Cannot find color provider block %s for block %s".formatted(properties.colorProvider().get(), entry.getKey()));
            } else {
                blocksToAdd.add(Pair.of((Object)block, (Object)blockColors.computeIfAbsent(providerBlock, ColorProviderUtil::delegate)));
            }
            if ((item = block.method_8389()) == class_1802.field_8162 || addedItems.contains(item)) continue;
            addedItems.add(item);
            class_1792 providerItem = providerBlock.method_8389();
            if (providerItem != class_1802.field_8162) {
                itemsToAdd.add(Pair.of((Object)item, (Object)itemColors.computeIfAbsent(providerItem, ColorProviderUtil::delegate)));
                continue;
            }
            if (providerBlock == class_2246.field_10382) {
                itemsToAdd.add(Pair.of((Object)item, (stack, i) -> 4159204));
                continue;
            }
            itemsToAdd.add(Pair.of((Object)item, (Object)itemColors.computeIfAbsent(providerItem, $ -> ColorProviderUtil.delegateItemFallback(providerBlock))));
        }
        ClientProxy.registerColors(context, blocksToAdd, itemsToAdd);
    }
}

