/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import snownee.kiwi.Kiwi;
import snownee.kiwi.KiwiCommonConfig;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.shadowed.com.ezylang.evalex.Expression;
import snownee.kiwi.shadowed.com.ezylang.evalex.data.EvaluationValue;
import snownee.kiwi.util.KEval;
import snownee.kiwi.util.KUtil;

public class KiwiCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder builder = class_2170.method_9247((String)"kiwi");
        builder.then(class_2170.method_9247((String)"dev_env_rules").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"do_not_run_this_if_you_do_not_know_what_it_does").requires(ctx -> ctx.method_9259(2))).executes(ctx -> KiwiCommand.debugRules((class_2168)ctx.getSource()))));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(ctx -> ctx.method_9259(2))).then(class_2170.method_9244((String)"configFile", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String fileName = StringArgumentType.getString((CommandContext)ctx, (String)"configFile");
            if (KiwiConfigManager.refresh(fileName)) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.kiwi.reload.success", (Object[])new Object[]{fileName}), true);
                return 1;
            }
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43469((String)"commands.kiwi.reload.failed", (Object[])new Object[]{fileName}));
            return 0;
        })));
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"eval").requires(ctx -> ctx.method_9259(2))).executes(ctx -> KiwiCommand.evalHelp((class_2168)ctx.getSource(), class_2168::method_9213))).then(class_2170.method_9244((String)"expression", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> KiwiCommand.eval(StringArgumentType.getString((CommandContext)ctx, (String)"expression"), KiwiCommonConfig.evalPrintExpression, (class_2168)ctx.getSource(), (source, msg) -> source.method_9226(() -> msg, false), class_2168::method_9213))));
        dispatcher.register(builder);
    }

    private static int debugRules(class_2168 commandSourceStack) {
        class_2170 commands = commandSourceStack.method_9211().method_3734();
        List<String> rules = List.of("gamerule doDaylightCycle false", "gamerule doWeatherCycle false", "gamerule doMobLoot false", "gamerule doMobSpawning false", "gamerule keepInventory true", "gamerule doTraderSpawning false", "gamerule doInsomnia false", "difficulty peaceful", "kill @e[type=!minecraft:player]", "time set day", "weather clear", "gamerule doMobLoot true");
        for (String rule : rules) {
            commands.method_44252(commandSourceStack, rule);
        }
        return 1;
    }

    public static <T> int evalHelp(T ctx, BiConsumer<T, class_2561> send) {
        String url = "https://github.com/Snownee/Kiwi/wiki/Eval-Guide";
        send.accept(ctx, (class_2561)class_2561.method_43470((String)url).method_27694(s -> s.method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11749, url))));
        return 0;
    }

    public static <T> int eval(String expString, boolean print, T source, BiConsumer<T, class_2561> sendSuccess, BiConsumer<T, class_2561> sendFailure) {
        try {
            EvaluationValue value;
            if (print) {
                sendSuccess.accept(source, (class_2561)class_2561.method_43470((String)(">>> " + expString)).method_27692(class_124.field_1060));
            }
            String s = (value = new Expression(expString, KEval.config()).evaluate()).isNumberValue() ? new DecimalFormat("###,###.#####").format(value.getNumberValue()) : (value.isExpressionNode() || value.isBinaryValue() ? "[%s]".formatted(new Object[]{value.getDataType()}) : Objects.toString(value.getValue()));
            sendSuccess.accept(source, (class_2561)KUtil.clickToCopy(class_2561.method_43470((String)s)));
            return value.isNullValue() ? 0 : value.getNumberValue().intValue();
        }
        catch (Throwable e) {
            if (!Platform.isProduction()) {
                Kiwi.LOGGER.error(expString, e);
            }
            sendFailure.accept(source, (class_2561)class_2561.method_43470((String)"%s - %s".formatted(e, e.getLocalizedMessage())));
            return 0;
        }
    }
}

