/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.GroupSetting;
import snownee.kiwi.Kiwi;
import snownee.kiwi.KiwiGO;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.KiwiModules;
import snownee.kiwi.ModContext;
import snownee.kiwi.block.IKiwiBlock;
import snownee.kiwi.item.ItemCategoryFiller;
import snownee.kiwi.item.ModBlockItem;
import snownee.kiwi.loader.ClientPlatform;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.loader.event.InitEvent;
import snownee.kiwi.loader.event.PostInitEvent;
import snownee.kiwi.util.KUtil;

public final class KiwiModuleContainer {
    public final AbstractModule module;
    public final ModContext context;
    @Nullable
    public GroupSetting groupSetting;
    final RegistryEntryStore registries = new RegistryEntryStore();
    Map<class_2248, class_1792.class_1793> blockItemBuilders = Maps.newHashMap();
    Set<Object> noCategories = Sets.newHashSet();
    Set<class_2248> noItems = Sets.newHashSet();

    public KiwiModuleContainer(class_2960 id, AbstractModule module, ModContext context) {
        this.module = module;
        this.context = context;
        module.uid = id;
    }

    public <T> void register(KiwiGO<T> go) {
        KiwiModule.Category group;
        this.registries.put(go);
        if (go.field != null && (group = go.field.getAnnotation(KiwiModule.Category.class)) != null) {
            go.groupSetting = GroupSetting.of(group, this.groupSetting);
        }
    }

    public void loadGameObjects() {
        boolean useOwnGroup;
        this.context.setActiveContainer();
        if (this.groupSetting == null) {
            KiwiModule.Category group = this.module.getClass().getDeclaredAnnotation(KiwiModule.Category.class);
            if (group != null && group.value().length > 0) {
                useOwnGroup = false;
                this.groupSetting = GroupSetting.of(group, null);
            } else {
                useOwnGroup = true;
            }
        } else {
            useOwnGroup = false;
        }
        String modId = Objects.requireNonNull(this.module.uid).method_12836();
        class_1792.class_1793 tmpBuilder = null;
        Field tmpBuilderField = null;
        for (Field field : this.module.getClass().getFields()) {
            int mods;
            if (field.getAnnotation(KiwiModule.Skip.class) != null || !Modifier.isPublic(mods = field.getModifiers()) || !Modifier.isStatic(mods)) continue;
            KiwiModule.Name nameAnnotation = field.getAnnotation(KiwiModule.Name.class);
            class_2960 id = nameAnnotation != null ? KUtil.RL(nameAnnotation.value(), modId) : KUtil.RL(field.getName().toLowerCase(Locale.ENGLISH), modId);
            Objects.requireNonNull(id);
            if (field.getType() == this.module.getClass() && "instance".equals(id.method_12832()) && id.method_12836().equals(modId)) {
                try {
                    field.set(null, this.module);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    Kiwi.LOGGER.error("Kiwi failed to inject module instance to module class: %s".formatted(this.module.uid), (Throwable)e);
                }
                continue;
            }
            Object o = null;
            try {
                o = field.get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                Kiwi.LOGGER.error("Kiwi failed to catch game object: %s".formatted(field), (Throwable)e);
            }
            if (o == null) continue;
            if (o instanceof class_1792.class_1793) {
                class_1792.class_1793 properties;
                tmpBuilder = properties = (class_1792.class_1793)o;
                tmpBuilderField = field;
                continue;
            }
            if (!(o instanceof KiwiGO)) continue;
            KiwiGO go = (KiwiGO)o;
            try {
                class_5321<class_2378<?>> registryKey;
                go.field = field;
                boolean isRef = go instanceof KiwiGO.Ref;
                if (!isRef) {
                    o = go.getOrCreate();
                }
                if ((registryKey = go.findRegistry()) == null) {
                    throw new IllegalArgumentException("Kiwi failed to find registry for %s".formatted(go.value.getClass()));
                }
                class_5321 resourceKey = class_5321.method_29179(registryKey, (class_2960)id);
                go.setKey(resourceKey);
                if (isRef) continue;
                if (o instanceof class_2248) {
                    if (field.getAnnotation(KiwiModule.NoItem.class) != null) {
                        this.noItems.add((class_2248)o);
                    }
                    this.checkNoGroup(field, o);
                    if (tmpBuilder != null) {
                        this.blockItemBuilders.put((class_2248)o, tmpBuilder);
                        try {
                            tmpBuilderField.set(this.module, null);
                        }
                        catch (Exception e) {
                            Kiwi.LOGGER.error("Mod %s failed to clean used item builder: %s".formatted(modId, go), (Throwable)e);
                        }
                    }
                } else if (o instanceof class_1792) {
                    this.checkNoGroup(field, o);
                } else if (o instanceof class_1761 && useOwnGroup && this.groupSetting == null) {
                    this.groupSetting = new GroupSetting(new String[]{id.toString()}, null);
                }
                this.register(go);
                if (class_7924.field_41208 == registryKey) {
                    BiConsumer<KiwiModuleContainer, KiwiGO> decorator = this.module.decorators.getOrDefault(registryKey, (a, b) -> {});
                    decorator.accept(this, go);
                    go.register();
                }
                tmpBuilder = null;
                tmpBuilderField = null;
            }
            catch (Throwable e) {
                throw new IllegalStateException("Mod %s failed to register game object: %s".formatted(modId, go), e);
            }
        }
    }

    private void checkNoGroup(Field field, Object o) {
        if (field.getAnnotation(KiwiModule.NoCategory.class) != null) {
            this.noCategories.add(o);
        }
    }

    public void registerGameObjects(class_5321<? extends class_2378<?>> registryKey) {
        if (class_7924.field_41208 == registryKey) {
            return;
        }
        this.context.setActiveContainer();
        Collection entries = this.registries.registries.get((Object)registryKey.method_29177());
        BiConsumer<KiwiModuleContainer, KiwiGO> decorator = this.module.decorators.getOrDefault(registryKey, (a, b) -> {});
        if (class_7924.field_41197 == registryKey) {
            this.registries.get(class_7924.field_41254).forEach(e -> {
                class_1747 item;
                Object patt0$temp;
                if (this.noItems.contains(e.get())) {
                    return;
                }
                class_1792.class_1793 builder = this.blockItemBuilders.get(e.get());
                if (builder == null) {
                    builder = new class_1792.class_1793();
                }
                if ((patt0$temp = e.get()) instanceof IKiwiBlock) {
                    IKiwiBlock kiwiBlock = (IKiwiBlock)patt0$temp;
                    item = kiwiBlock.createItem(builder);
                } else {
                    item = new ModBlockItem((class_2248)e.get(), builder);
                }
                if (this.noCategories.contains(e.get())) {
                    this.noCategories.add(item);
                }
                KiwiGO.Direct<class_1747> itemEntry = new KiwiGO.Direct<class_1747>(item);
                itemEntry.setKey((class_5321<class_1747>)class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)e.key()));
                itemEntry.groupSetting = e.groupSetting;
                entries.add(itemEntry);
            });
            LinkedHashSet groupSettings = Sets.newLinkedHashSet();
            MutableObject prevSetting = new MutableObject();
            if (this.groupSetting != null) {
                prevSetting.setValue((Object)this.groupSetting);
                groupSettings.add(this.groupSetting);
            }
            entries.forEach(e -> {
                class_1792 item = (class_1792)e.get();
                if (this.noCategories.contains(item)) {
                    prevSetting.setValue((Object)this.groupSetting);
                    return;
                }
                ItemCategoryFiller filler = item instanceof ItemCategoryFiller ? (ItemCategoryFiller)item : (tab, flags, hasPermissions, items) -> items.add(new class_1799((class_1935)item));
                if (e.groupSetting != null) {
                    e.groupSetting.apply(filler);
                    groupSettings.add(e.groupSetting);
                    prevSetting.setValue((Object)e.groupSetting);
                } else if (prevSetting.getValue() != null) {
                    ((GroupSetting)prevSetting.getValue()).apply(filler);
                }
            });
            groupSettings.forEach(GroupSetting::postApply);
        }
        entries.forEach(e -> {
            decorator.accept(this, (KiwiGO)e);
            e.register();
        });
        if (class_7924.field_41197 == registryKey) {
            this.blockItemBuilders = null;
            this.noCategories = null;
            this.noItems = null;
        } else if (class_7924.field_41254 == registryKey && Platform.isPhysicalClient() && !Platform.isDataGen()) {
            class_1921 solid = class_1921.method_23577();
            HashMap cache = Maps.newHashMap();
            entries.forEach(e -> {
                class_1921 type;
                KiwiModule.RenderLayer layer;
                class_2248 block = (class_2248)e.get();
                if (e.field != null && (layer = e.field.getAnnotation(KiwiModule.RenderLayer.class)) != null && (type = (class_1921)layer.value().value) != solid && type != null) {
                    ClientPlatform.setRenderType(block, type);
                    return;
                }
                Class<?> klass = block.getClass();
                type = cache.computeIfAbsent(klass, k -> {
                    while (k != class_2248.class) {
                        KiwiModule.RenderLayer layer = k.getDeclaredAnnotation(KiwiModule.RenderLayer.class);
                        if (layer != null) {
                            return (class_1921)layer.value().value;
                        }
                        k = k.getSuperclass();
                    }
                    return solid;
                });
                if (type != solid && type != null) {
                    ClientPlatform.setRenderType(block, type);
                }
            });
        }
    }

    public void addRegistries() {
        this.context.setActiveContainer();
        this.module.addRegistries();
    }

    public void addEntries() {
        this.context.setActiveContainer();
        this.module.addEntries();
        this.registries.registries.keySet().stream().map(class_5321::method_29180).forEach(KiwiModules.ALL_USED_REGISTRIES::add);
        KiwiModules.ALL_USED_REGISTRIES.forEach(this::registerGameObjects);
    }

    public void init(InitEvent event) {
        this.context.setActiveContainer();
        this.module.init(event);
    }

    public void postInit(PostInitEvent event) {
        this.context.setActiveContainer();
        this.module.postInit(event);
    }

    public <T> List<T> getRegistries(class_5321<class_2378<T>> registry) {
        return this.getRegistryEntries(registry).map(KiwiGO::get).toList();
    }

    public <T> Stream<KiwiGO<T>> getRegistryEntries(class_5321<class_2378<T>> registry) {
        return this.registries.get(registry).stream();
    }

    public static final class RegistryEntryStore {
        final Multimap<class_2960, KiwiGO<?>> registries = MultimapBuilder.ListMultimapBuilder.linkedHashKeys().linkedListValues().build();

        <T> void put(KiwiGO<T> entry) {
            this.registries.put((Object)entry.resourceKey().method_41185(), entry);
        }

        <T> Collection<KiwiGO<T>> get(class_5321<class_2378<T>> registry) {
            return this.registries.get((Object)registry.method_29177());
        }
    }
}

