/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.impl.gui.FabricGuiEntry;
import net.fabricmc.loader.impl.gui.FabricStatusTree;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1535;
import net.minecraft.class_1741;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1865;
import net.minecraft.class_1921;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2314;
import net.minecraft.class_2378;
import net.minecraft.class_2396;
import net.minecraft.class_2591;
import net.minecraft.class_2806;
import net.minecraft.class_2939;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3448;
import net.minecraft.class_3611;
import net.minecraft.class_3773;
import net.minecraft.class_3816;
import net.minecraft.class_3827;
import net.minecraft.class_3828;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_4140;
import net.minecraft.class_4149;
import net.minecraft.class_4158;
import net.minecraft.class_4168;
import net.minecraft.class_4170;
import net.minecraft.class_4648;
import net.minecraft.class_4652;
import net.minecraft.class_4663;
import net.minecraft.class_4996;
import net.minecraft.class_5142;
import net.minecraft.class_5202;
import net.minecraft.class_5321;
import net.minecraft.class_5338;
import net.minecraft.class_5339;
import net.minecraft.class_5342;
import net.minecraft.class_5650;
import net.minecraft.class_5657;
import net.minecraft.class_5669;
import net.minecraft.class_5712;
import net.minecraft.class_5717;
import net.minecraft.class_5864;
import net.minecraft.class_6018;
import net.minecraft.class_6123;
import net.minecraft.class_6647;
import net.minecraft.class_6798;
import net.minecraft.class_6875;
import net.minecraft.class_7106;
import net.minecraft.class_7151;
import net.minecraft.class_7375;
import net.minecraft.class_7388;
import net.minecraft.class_7444;
import net.minecraft.class_7706;
import net.minecraft.class_7924;
import net.minecraft.class_9331;
import net.minecraft.class_9360;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiAnnotationData;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.KiwiModuleContainer;
import snownee.kiwi.KiwiModules;
import snownee.kiwi.LoadingContext;
import snownee.kiwi.Mod;
import snownee.kiwi.ModContext;
import snownee.kiwi.RegistryLookup;
import snownee.kiwi.RenderLayerEnum;
import snownee.kiwi.block.def.BlockDefinition;
import snownee.kiwi.block.def.SimpleBlockDefinition;
import snownee.kiwi.build.KiwiMetadata;
import snownee.kiwi.build.KiwiMetadataParser;
import snownee.kiwi.command.KiwiCommand;
import snownee.kiwi.config.ConfigHandler;
import snownee.kiwi.config.KiwiConfig;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.customization.CustomizationHooks;
import snownee.kiwi.loader.ClientPlatform;
import snownee.kiwi.loader.KiwiMetadataLoader;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.loader.event.InitEvent;
import snownee.kiwi.loader.event.PostInitEvent;
import snownee.kiwi.network.KNetworking;
import snownee.kiwi.util.KUtil;
import snownee.kiwi.util.toposort.TopologicalSort;

@Mod(value="kiwi")
public class Kiwi
implements ClientModInitializer,
DedicatedServerModInitializer {
    public static final String ID = "kiwi";
    public static final RegistryLookup registryLookup = new RegistryLookup();
    static final Marker MARKER = MarkerFactory.getMarker((String)"INIT");
    private static final Map<String, class_5321<class_1761>> GROUPS = Maps.newHashMap();
    public static final Logger LOGGER = LogUtils.getLogger();
    public static Map<class_2960, Boolean> defaultOptions = Maps.newHashMap();
    public static MinecraftServer currentServer;
    private static Multimap<String, KiwiAnnotationData> moduleData;
    private static Map<KiwiAnnotationData, String> conditions;
    private static boolean tagsUpdated;
    public static boolean enableDataModule;
    private static boolean initialized;

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)ID, (String)path);
    }

    private static boolean shouldLoad(KiwiAnnotationData annotationData, String dist) {
        try {
            String target = annotationData.getTarget();
            if (Platform.isProduction() && target.startsWith("snownee.kiwi.test.")) {
                return false;
            }
            ClassNode clazz = new ClassNode(458752);
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(target.replace('.', '/') + ".class");
            ClassReader classReader = new ClassReader(is);
            classReader.accept((ClassVisitor)clazz, 0);
            if (clazz.visibleAnnotations != null) {
                String ONLYIN = Type.getDescriptor(Environment.class);
                for (AnnotationNode node : clazz.visibleAnnotations) {
                    int i;
                    if (node.values == null || !ONLYIN.equals(node.desc) || (i = node.values.indexOf("value")) == -1 || node.values.get(i + 1).equals(dist)) continue;
                    return false;
                }
            }
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static void registerRegistry(class_5321<? extends class_2378<?>> registry, Class<?> baseClass) {
        Objects.requireNonNull(registryLookup);
        Kiwi.registryLookup.registries.put(baseClass, registry);
    }

    private static void registerRegistries() throws Exception {
        Kiwi.registerRegistry(class_7924.field_41273, class_5712.class);
        Kiwi.registerRegistry(class_7924.field_41225, class_3414.class);
        Kiwi.registerRegistry(class_7924.field_41270, class_3611.class);
        Kiwi.registerRegistry(class_7924.field_41208, class_1291.class);
        Kiwi.registerRegistry(class_7924.field_41254, class_2248.class);
        Kiwi.registerRegistry(class_7924.field_41266, class_1299.class);
        Kiwi.registerRegistry(class_7924.field_41197, class_1792.class);
        Kiwi.registerRegistry(class_7924.field_41215, class_1842.class);
        Kiwi.registerRegistry(class_7924.field_41210, class_2396.class);
        Kiwi.registerRegistry(class_7924.field_41255, class_2591.class);
        Kiwi.registerRegistry(class_7924.field_41209, class_1535.class);
        Kiwi.registerRegistry(class_7924.field_41261, class_2806.class);
        Kiwi.registerRegistry(class_7924.field_41219, class_3827.class);
        Kiwi.registerRegistry(class_7924.field_41214, class_4996.class);
        Kiwi.registerRegistry(class_7924.field_41207, class_3917.class);
        Kiwi.registerRegistry(class_7924.field_41217, class_3956.class);
        Kiwi.registerRegistry(class_7924.field_41216, class_1865.class);
        Kiwi.registerRegistry(class_7924.field_41251, class_1320.class);
        Kiwi.registerRegistry(class_7924.field_41213, class_5717.class);
        Kiwi.registerRegistry(class_7924.field_41262, class_2314.class);
        Kiwi.registerRegistry(class_7924.field_41226, class_3448.class);
        Kiwi.registerRegistry(class_7924.field_41235, class_3854.class);
        Kiwi.registerRegistry(class_7924.field_41234, class_3852.class);
        Kiwi.registerRegistry(class_7924.field_41212, class_4158.class);
        Kiwi.registerRegistry(class_7924.field_41206, class_4140.class);
        Kiwi.registerRegistry(class_7924.field_41221, class_4149.class);
        Kiwi.registerRegistry(class_7924.field_41220, class_4170.class);
        Kiwi.registerRegistry(class_7924.field_41222, class_4168.class);
        Kiwi.registerRegistry(class_7924.field_41202, class_5338.class);
        Kiwi.registerRegistry(class_7924.field_41199, class_5339.class);
        Kiwi.registerRegistry(class_7924.field_41198, class_5342.class);
        Kiwi.registerRegistry(class_7924.field_41201, class_5657.class);
        Kiwi.registerRegistry(class_7924.field_41200, class_5650.class);
        Kiwi.registerRegistry(class_7924.field_41203, class_5669.class);
        Kiwi.registerRegistry(class_7924.field_41269, class_5864.class);
        Kiwi.registerRegistry(class_7924.field_41196, class_6018.class);
        Kiwi.registerRegistry(class_7924.field_41274, class_6123.class);
        Kiwi.registerRegistry(class_7924.field_41256, class_6647.class);
        Kiwi.registerRegistry(class_7924.field_41258, class_2939.class);
        Kiwi.registerRegistry(class_7924.field_41267, class_3031.class);
        Kiwi.registerRegistry(class_7924.field_41228, class_6875.class);
        Kiwi.registerRegistry(class_7924.field_41227, class_3773.class);
        Kiwi.registerRegistry(class_7924.field_41231, class_7151.class);
        Kiwi.registerRegistry(class_7924.field_41211, class_6798.class);
        Kiwi.registerRegistry(class_7924.field_41257, class_4652.class);
        Kiwi.registerRegistry(class_7924.field_41271, class_4648.class);
        Kiwi.registerRegistry(class_7924.field_41233, class_5142.class);
        Kiwi.registerRegistry(class_7924.field_41218, class_7388.class);
        Kiwi.registerRegistry(class_7924.field_41232, class_4663.class);
        Kiwi.registerRegistry(class_7924.field_41268, class_5202.class);
        Kiwi.registerRegistry(class_7924.field_41230, class_3828.class);
        Kiwi.registerRegistry(class_7924.field_41229, class_3816.class);
        Kiwi.registerRegistry(class_7924.field_41259, class_7375.class);
        Kiwi.registerRegistry(class_7924.field_41272, class_7106.class);
        Kiwi.registerRegistry(class_7924.field_41275, class_7444.class);
        Kiwi.registerRegistry(class_7924.field_44688, class_1761.class);
        Kiwi.registerRegistry(class_7924.field_48977, class_1741.class);
        Kiwi.registerRegistry(class_7924.field_49659, class_9331.class);
        Kiwi.registerRegistry(class_7924.field_49914, class_9360.class_8745.class);
    }

    public static void registerTab(String id, class_5321<class_1761> tab) {
        Validate.isTrue((!GROUPS.containsKey(id) ? 1 : 0) != 0, (String)"Already exists: %s", (Object[])new Object[]{id});
        GROUPS.put(id, tab);
    }

    private static void registerTabs() {
        Kiwi.registerTab("building_blocks", (class_5321<class_1761>)class_7706.field_40195);
        Kiwi.registerTab("colored_blocks", (class_5321<class_1761>)class_7706.field_41059);
        Kiwi.registerTab("combat", (class_5321<class_1761>)class_7706.field_40202);
        Kiwi.registerTab("food_and_drinks", (class_5321<class_1761>)class_7706.field_41061);
        Kiwi.registerTab("functional_blocks", (class_5321<class_1761>)class_7706.field_40197);
        Kiwi.registerTab("ingredients", (class_5321<class_1761>)class_7706.field_41062);
        Kiwi.registerTab("natural_blocks", (class_5321<class_1761>)class_7706.field_40743);
        Kiwi.registerTab("op_blocks", (class_5321<class_1761>)class_7706.field_41063);
        Kiwi.registerTab("redstone_blocks", (class_5321<class_1761>)class_7706.field_40198);
        Kiwi.registerTab("spawn_eggs", (class_5321<class_1761>)class_7706.field_40205);
        Kiwi.registerTab("tools_and_utilities", (class_5321<class_1761>)class_7706.field_41060);
    }

    @Nullable
    static class_5321<class_1761> getGroup(String path) {
        return GROUPS.get(path);
    }

    public static boolean isLoaded(class_2960 module) {
        return KiwiModules.isLoaded(module);
    }

    public static void onTagsUpdated() {
        tagsUpdated = true;
    }

    public static boolean areTagsUpdated() {
        return tagsUpdated;
    }

    public static void enableDataModule() {
        enableDataModule = true;
    }

    public void onInitializeClient() {
        Kiwi.onInitialize();
    }

    public void onInitializeServer() {
        Kiwi.onInitialize();
    }

    public static void onInitialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        try {
            Kiwi.registerRegistries();
            Kiwi.registerTabs();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        CustomizationHooks.init();
        if (!Platform.isProduction()) {
            Kiwi.enableDataModule();
        }
        HashMap classOptionalMap = Maps.newHashMap();
        String dist = Platform.isPhysicalClient() ? "client" : "server";
        List<String> mods = FabricLoader.getInstance().getAllMods().stream().map(ModContainer::getMetadata).filter($ -> !"builtin".equals($.getType())).map(ModMetadata::getId).toList();
        KiwiMetadataParser metadataParser = new KiwiMetadataParser();
        for (String mod : mods) {
            KiwiMetadataLoader loader;
            KiwiMetadata metadata;
            if (mod.startsWith("fabric") || (metadata = (loader = new KiwiMetadataLoader(mod)).apply(metadataParser)) == null) continue;
            if (!metadata.clientOnly()) {
                Kiwi.enableDataModule();
            }
            for (KiwiAnnotationData module : metadata.get("modules")) {
                if (!Kiwi.shouldLoad(module, dist)) continue;
                moduleData.put((Object)mod, (Object)module);
            }
            for (KiwiAnnotationData optional : metadata.get("optionals")) {
                if (!Kiwi.shouldLoad(optional, dist)) continue;
                classOptionalMap.put(optional.getTarget(), optional);
            }
            for (KiwiAnnotationData condition : metadata.get("conditions")) {
                if (!Kiwi.shouldLoad(condition, dist)) continue;
                conditions.put(condition, mod);
            }
            for (KiwiAnnotationData config : metadata.get("configs")) {
                if (!Kiwi.shouldLoad(config, dist)) continue;
                KiwiConfig.ConfigType type = null;
                try {
                    type = KiwiConfig.ConfigType.valueOf((String)config.getData().get("type"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                KiwiConfig.ConfigType configType = type = type == null ? KiwiConfig.ConfigType.COMMON : type;
                if (type == KiwiConfig.ConfigType.CLIENT && !Platform.isPhysicalClient() && !Platform.isDataGen()) continue;
                try {
                    boolean hasModules;
                    Class<?> clazz = Class.forName(config.getTarget());
                    String fileName = (String)config.getData().get("value");
                    boolean bl = hasModules = type == KiwiConfig.ConfigType.COMMON && Strings.isNullOrEmpty((String)fileName);
                    if (Strings.isNullOrEmpty((String)fileName)) {
                        fileName = String.format("%s-%s", mod, type.extension());
                    }
                    new ConfigHandler(mod, fileName, type, clazz, hasModules);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error(MARKER, "Failed to load config class {}", (Object)config.getTarget());
                }
            }
            for (KiwiAnnotationData packet : metadata.get("packets")) {
                if (!Kiwi.shouldLoad(packet, dist)) continue;
                KNetworking.processClass(packet);
            }
        }
        LOGGER.info(MARKER, "Processing " + moduleData.size() + " KiwiModule annotations");
        for (Map.Entry entry : moduleData.entries()) {
            Boolean defaultEnabled;
            String modid;
            KiwiAnnotationData optional = (KiwiAnnotationData)classOptionalMap.get(((KiwiAnnotationData)entry.getValue()).getTarget());
            if (optional == null || !Platform.isModLoaded(modid = (String)entry.getKey())) continue;
            String name = (String)((KiwiAnnotationData)entry.getValue()).getData().get("value");
            if (Strings.isNullOrEmpty((String)name)) {
                name = "core";
            }
            if ((defaultEnabled = (Boolean)optional.getData().get("defaultEnabled")) == null) {
                defaultEnabled = Boolean.TRUE;
            }
            defaultOptions.put(class_2960.method_60655((String)modid, (String)name), defaultEnabled);
        }
        KiwiConfigManager.init();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> KiwiCommand.register((CommandDispatcher<class_2168>)dispatcher));
        ServerLifecycleEvents.SERVER_STARTING.register(Kiwi::serverInit);
        ServerLifecycleEvents.SERVER_STOPPED.register($ -> {
            currentServer = null;
        });
        AttackEntityCallback.EVENT.register(KUtil::onAttackEntity);
        if (Platform.isPhysicalClient()) {
            RenderLayerEnum.CUTOUT.value = class_1921.method_23581();
            RenderLayerEnum.CUTOUT_MIPPED.value = class_1921.method_23579();
            RenderLayerEnum.TRANSLUCENT.value = class_1921.method_23583();
            ClientPlatform.init();
        }
        Kiwi.preInit();
    }

    private static void preInit() {
        Object moduleLoadingQueue;
        String dependencies;
        Object name;
        HashSet disabledModules = Sets.newHashSet();
        conditions.forEach((k, v) -> {
            try {
                Class<?> clazz = Class.forName(k.getTarget());
                String methodName = (String)k.getData().get("method");
                List<String> values = (List<String>)k.getData().get("value");
                if (values == null) {
                    values = List.of(v);
                }
                List<class_2960> ids = values.stream().map(s -> KUtil.RL(s, v)).toList();
                for (class_2960 id : ids) {
                    LoadingContext context = new LoadingContext(id);
                    try {
                        Boolean bl = (Boolean)MethodUtils.invokeExactStaticMethod(clazz, (String)methodName, (Object[])new Object[]{context});
                        if (bl.booleanValue()) continue;
                        disabledModules.add(id);
                    }
                    catch (Exception e) {
                        disabledModules.add(id);
                        throw e;
                        return;
                    }
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error(MARKER, "Failed to access to LoadingCondition: %s".formatted(k), (Throwable)e);
            }
        });
        HashMap infos = Maps.newHashMap();
        boolean checkDep = false;
        block4: for (Map.Entry entry : moduleData.entries()) {
            class_2960 rl;
            KiwiAnnotationData module = (KiwiAnnotationData)entry.getValue();
            String modid = (String)entry.getKey();
            if (!Platform.isModLoaded(modid)) continue;
            name = (String)module.getData().get("value");
            if (Strings.isNullOrEmpty((String)name)) {
                name = "core";
            }
            if (disabledModules.contains(rl = class_2960.method_60655((String)modid, (String)name)) || KiwiConfigManager.modules.containsKey(rl) && !KiwiConfigManager.modules.get(rl).get().booleanValue()) continue;
            Info info = new Info(rl, module.getTarget());
            dependencies = (String)module.getData().get("dependencies");
            List<String> rules = Stream.of(Strings.nullToEmpty((String)dependencies).split(";")).filter(s -> !Strings.isNullOrEmpty((String)s)).toList();
            for (String rule : rules) {
                if (rule.startsWith("@")) {
                    info.moduleRules.add(KUtil.RL(rule.substring(1), modid));
                    checkDep = true;
                    continue;
                }
                if (Platform.isModLoaded(rule)) continue;
                continue block4;
            }
            infos.put(rl, info);
        }
        if (checkDep) {
            Iterator<KiwiModuleContainer> errorList = Lists.newLinkedList();
            block6: for (Info i : infos.values()) {
                for (class_2960 id : i.moduleRules) {
                    if (infos.containsKey(id)) continue;
                    errorList.add((KiwiModuleContainer)((Object)i));
                    continue block6;
                }
            }
            FabricStatusTree tree = new FabricStatusTree("Kiwi error when loading modules", "The following modules failed to load because of missing dependencies:");
            FabricStatusTree.FabricStatusTab tab = tree.addTab("Errors");
            name = errorList.iterator();
            while (name.hasNext()) {
                Info i = (Info)name.next();
                ModContainer modContainer = (ModContainer)FabricLoader.getInstance().getModContainer(i.id.method_12836()).orElseThrow();
                dependencies = StringUtils.join(i.moduleRules, (String)", ");
                String message = String.format("%s: Module %s requires the following modules to be enabled: %s", modContainer.getMetadata().getId(), i.id, dependencies);
                tab.node.addMessage(message, FabricStatusTree.FabricTreeWarningLevel.WARN);
            }
            if (!errorList.isEmpty()) {
                try {
                    FabricGuiEntry.open((FabricStatusTree)tree);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return;
            }
            MutableGraph graph = GraphBuilder.directed().allowsSelfLoops(false).expectedNodeCount(infos.size()).build();
            infos.keySet().forEach(arg_0 -> ((MutableGraph)graph).addNode(arg_0));
            infos.values().forEach($ -> $.moduleRules.forEach(r -> graph.putEdge(r, (Object)$.id)));
            moduleLoadingQueue = TopologicalSort.topologicalSort(graph, null);
        } else {
            moduleLoadingQueue = ImmutableList.copyOf(infos.keySet());
        }
        for (class_2960 id : moduleLoadingQueue) {
            Info info = (Info)infos.get(id);
            ModContext context = ModContext.get(id.method_12836());
            context.setActiveContainer();
            try {
                KiwiModule.ClientCompanion clientCompanion;
                Class<?> clazz = Class.forName(info.className);
                Kiwi.instantiateModule(id, clazz, context);
                if (!Platform.isPhysicalClient() || (clientCompanion = clazz.getDeclaredAnnotation(KiwiModule.ClientCompanion.class)) == null) continue;
                Kiwi.instantiateModule(id.method_48331("_client"), clientCompanion.value(), context);
            }
            catch (Exception e) {
                LOGGER.error(MARKER, "Kiwi failed to initialize module class: %s".formatted(info.className), (Throwable)e);
            }
        }
        moduleData.clear();
        moduleData = null;
        defaultOptions.clear();
        defaultOptions = null;
        conditions.clear();
        conditions = null;
        KiwiModules.fire(KiwiModuleContainer::addRegistries);
        for (KiwiModuleContainer container : KiwiModules.get()) {
            container.loadGameObjects();
        }
        KiwiModules.ALL_USED_REGISTRIES.add(class_7924.field_44688);
        KiwiModules.ALL_USED_REGISTRIES.add(class_7924.field_41197);
        KiwiModules.fire(KiwiModuleContainer::addEntries);
        if (CustomizationHooks.isEnabled()) {
            CustomizationHooks.initLoader();
        }
        ArrayList entries = Lists.newArrayList();
        for (KiwiModuleContainer container : KiwiModules.get()) {
            class_2960 uid = container.module.uid;
            if (ID.equals(uid.method_12836()) && uid.method_12832().startsWith("contributors")) continue;
            LOGGER.info(MARKER, "Module [{}] initialized", (Object)uid);
            container.registries.registries.asMap().forEach((key, values) -> {
                if (!values.isEmpty()) {
                    entries.add("%s: %s".formatted(KUtil.trimRL(key), values.size()));
                }
            });
            if (entries.isEmpty()) continue;
            LOGGER.info(MARKER, "\t\t" + String.join((CharSequence)", ", entries));
            entries.clear();
        }
    }

    private static void instantiateModule(class_2960 id, Class<?> clazz, ModContext context) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        AbstractModule instance = (AbstractModule)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        KiwiModules.add(id, instance, context);
    }

    private static void init() {
        KiwiConfigManager.refresh();
        InitEvent e = new InitEvent();
        KiwiModules.fire(m -> m.init(e));
        BlockDefinition.registerFactory(SimpleBlockDefinition.Factory.INSTANCE);
    }

    public static void clientInit(class_310 mc) {
        Kiwi.init();
        Kiwi.postInit();
        Kiwi.loadComplete();
    }

    private static void serverInit(MinecraftServer server) {
        currentServer = server;
        if (server.method_3816()) {
            Kiwi.init();
            Kiwi.postInit();
            Kiwi.loadComplete();
        }
    }

    private static void postInit() {
        PostInitEvent e = new PostInitEvent();
        KiwiModules.fire(m -> m.postInit(e));
        KiwiModules.clear();
    }

    private static void loadComplete() {
        Kiwi.registryLookup.cache.invalidateAll();
    }

    static {
        moduleData = ArrayListMultimap.create();
        conditions = Maps.newHashMap();
    }

    private record Info(class_2960 id, String className, List<class_2960> moduleRules) {
        Info(class_2960 id, String className) {
            this(id, className, Lists.newArrayList());
        }
    }
}

