/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import com.google.common.collect.Maps;
import com.mojang.datafixers.types.Type;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.minecraft.class_1299;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.KiwiGO;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.KiwiModuleContainer;
import snownee.kiwi.KiwiModules;
import snownee.kiwi.block.entity.InheritanceBlockEntityType;
import snownee.kiwi.loader.event.InitEvent;
import snownee.kiwi.loader.event.PostInitEvent;

public abstract class AbstractModule {
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    protected final Map<class_5321<? extends class_2378<?>>, BiConsumer<KiwiModuleContainer, KiwiGO<?>>> decorators = Maps.newIdentityHashMap();
    @Nullable
    public class_2960 uid;

    protected static <T> KiwiGO<T> go(Supplier<? extends T> factory) {
        return new KiwiGO<T>(factory);
    }

    protected static <T> KiwiGO<T> go(Supplier<? extends T> factory, class_5321<? extends class_2378<?>> registryKey) {
        return new KiwiGO.RegistrySpecified<T>(factory, registryKey);
    }

    protected static <T> KiwiGO<T> ref(class_5321<? extends class_2378<?>> registryKey) {
        return new KiwiGO.Ref(registryKey);
    }

    protected static class_1792.class_1793 itemProp() {
        return new class_1792.class_1793();
    }

    protected static class_4970.class_2251 blockProp() {
        return class_4970.class_2251.method_9637();
    }

    protected static class_4970.class_2251 blockProp(class_4970 block) {
        return class_4970.class_2251.method_9630((class_4970)block);
    }

    @SafeVarargs
    public static <T extends class_2586> KiwiGO<class_2591<T>> blockEntity(FabricBlockEntityTypeBuilder.Factory<? extends T> factory, Type<?> datafixer, Supplier<? extends class_2248> ... blocks) {
        return AbstractModule.go(() -> FabricBlockEntityTypeBuilder.create((FabricBlockEntityTypeBuilder.Factory)factory, (class_2248[])((class_2248[])Stream.of(blocks).map(Supplier::get).toArray(class_2248[]::new))).build(datafixer));
    }

    public static <T extends class_2586> KiwiGO<class_2591<T>> blockEntity(FabricBlockEntityTypeBuilder.Factory<? extends T> factory, Type<?> datafixer, Class<? extends class_2248> blockClass) {
        return AbstractModule.go(() -> new InheritanceBlockEntityType(factory, blockClass, datafixer));
    }

    public static class_1761.class_7913 itemCategory(String namespace, String path, Supplier<class_1799> icon) {
        return FabricItemGroup.builder().method_47321((class_2561)class_2561.method_43471((String)"itemGroup.%s.%s".formatted(namespace, path))).method_47320(icon);
    }

    public static class_6862<class_1792> itemTag(String namespace, String path) {
        return AbstractModule.tag(class_7924.field_41197, namespace, path);
    }

    public static class_6862<class_1299<?>> entityTag(String namespace, String path) {
        return AbstractModule.tag(class_7924.field_41266, namespace, path);
    }

    public static class_6862<class_2248> blockTag(String namespace, String path) {
        return AbstractModule.tag(class_7924.field_41254, namespace, path);
    }

    public static class_6862<class_3611> fluidTag(String namespace, String path) {
        return AbstractModule.tag(class_7924.field_41270, namespace, path);
    }

    public static <T> class_6862<T> tag(class_5321<? extends class_2378<T>> registryKey, String namespace, String path) {
        return class_6862.method_40092(registryKey, (class_2960)class_2960.method_60655((String)namespace, (String)path));
    }

    public static class_6862<class_1792> itemTag(String id) {
        return AbstractModule.tag(class_7924.field_41197, id);
    }

    public static class_6862<class_1299<?>> entityTag(String id) {
        return AbstractModule.tag(class_7924.field_41266, id);
    }

    public static class_6862<class_2248> blockTag(String id) {
        return AbstractModule.tag(class_7924.field_41254, id);
    }

    public static class_6862<class_3611> fluidTag(String id) {
        return AbstractModule.tag(class_7924.field_41270, id);
    }

    public static <T> class_6862<T> tag(class_5321<? extends class_2378<T>> registryKey, String id) {
        class_2960 location;
        if (id.contains(":")) {
            location = class_2960.method_60654((String)id);
        } else {
            Class callerClass = STACK_WALKER.walk(stream -> stream.map(StackWalker.StackFrame::getDeclaringClass).filter(cls -> cls != AbstractModule.class).findFirst()).orElse(null);
            if (callerClass == null) {
                throw new IllegalStateException("No caller class found");
            }
            KiwiModule annotation = callerClass.getDeclaredAnnotation(KiwiModule.class);
            if (annotation == null || annotation.modId().isEmpty()) {
                throw new IllegalStateException("No KiwiModule modId found on " + callerClass.getName());
            }
            location = class_2960.method_60655((String)annotation.modId(), (String)id);
        }
        return class_6862.method_40092(registryKey, (class_2960)location);
    }

    public void addRegistries() {
    }

    protected void addEntries() {
    }

    protected void init(InitEvent event) {
    }

    protected void postInit(PostInitEvent event) {
    }

    public class_2960 id(String path) {
        return class_2960.method_60655((String)Objects.requireNonNull(this.uid).method_12836(), (String)path);
    }

    public KiwiModuleContainer container() {
        return KiwiModules.get(Objects.requireNonNull(this.uid));
    }
}

