/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.ai;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.common.wreath.WreathData;
import net.mehvahdjukaar.snowyspirit.common.wreath.WreathHandler;
import net.mehvahdjukaar.snowyspirit.reg.ModMemoryModules;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4099;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class PlaceWreathTask
extends class_4097<class_1646> {
    private final float speedModifier;
    private class_2338 targetPos;
    private int ticksSinceReached = 0;
    private int cooldown = 400;

    public PlaceWreathTask(float speed) {
        super((Map)ImmutableMap.of(ModMemoryModules.WREATH_POS.get(), (Object)class_4141.field_18457, (Object)class_4140.field_18445, (Object)class_4141.field_18457), 190, 270);
        this.speedModifier = speed;
    }

    protected boolean checkExtraStartConditions(class_3218 pLevel, class_1646 pOwner) {
        if (this.cooldown-- > 0) {
            return false;
        }
        if (pOwner.method_6109()) {
            return false;
        }
        if (!SnowySpirit.isChristmasSeason(pOwner.method_37908())) {
            return false;
        }
        if (!PlatHelper.isMobGriefingOn((class_1937)pLevel, (class_1297)pOwner)) {
            this.cooldown = 1200;
            return false;
        }
        return true;
    }

    protected void start(class_3218 pLevel, class_1646 pEntity, long pGameTime) {
        this.cooldown = 8 * (10 + pLevel.field_9229.method_43048(10)) + pLevel.field_9229.method_43048(20);
        this.ticksSinceReached = 0;
        this.targetPos = PlaceWreathTask.getValidPlacementPos(pLevel, (class_1309)pEntity);
        if (this.targetPos != null) {
            pEntity.method_18868().method_18875(class_4140.field_18447);
            pEntity.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(this.targetPos, this.speedModifier, 1));
            PlaceWreathTask.displayAsHeldItem(pEntity, ModRegistry.WREATH.get().method_8389().method_7854());
        }
    }

    protected void stop(class_3218 pLevel, class_1646 pEntity, long pGameTime) {
        super.method_18926(pLevel, (class_1309)pEntity, pGameTime);
        PlaceWreathTask.clearHeldItem(pEntity);
        this.targetPos = null;
    }

    protected boolean canStillUse(class_3218 pLevel, class_1646 pEntity, long pGameTime) {
        return this.targetPos != null && PlaceWreathTask.isValidPlacementSpot(pLevel, this.targetPos);
    }

    protected void tick(class_3218 pLevel, class_1646 pOwner, long pGameTime) {
        if (this.targetPos != null) {
            pOwner.method_18868().method_18875(class_4140.field_18447);
            pOwner.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(this.targetPos, this.speedModifier, 2));
            pOwner.method_18868().method_18878(class_4140.field_18446, (Object)new class_4099(this.targetPos));
            if (this.targetPos.method_19769((class_2374)pOwner.method_19538(), 2.3)) {
                ++this.ticksSinceReached;
                if (this.ticksSinceReached > 20) {
                    if (WreathHandler.placeWreathOnDoor(this.targetPos, (class_1937)pLevel)) {
                        pOwner.method_18868().method_18878(ModMemoryModules.WREATH_POS.get(), (Object)class_4208.method_19443((class_5321)pLevel.method_27983(), (class_2338)this.targetPos));
                    }
                    this.targetPos = null;
                }
            }
        }
    }

    @Nullable
    private static class_2338 getValidPlacementPos(class_3218 pLevel, class_1309 pWalker) {
        class_5819 random = pWalker.method_59922();
        class_2338 targetPos = pWalker.method_24515();
        for (int i = 0; i < 6; ++i) {
            class_2338 pos = targetPos.method_10069(random.method_43048(20) - 10, random.method_43048(6) - 3, random.method_43048(20) - 10);
            if (!PlaceWreathTask.isValidPlacementSpot(pLevel, pos)) continue;
            return pos;
        }
        return null;
    }

    public static boolean isValidPlacementSpot(class_3218 serverLevel, class_2338 pos) {
        class_2680 state = serverLevel.method_8320(pos);
        if (state.method_26204() instanceof class_2323) {
            boolean lower = state.method_11654((class_2769)class_2323.field_10946) == class_2756.field_12607;
            WreathData c = WreathData.getAt((class_1937)serverLevel, pos);
            return c != null && (lower ? !c.hasWreathAt(pos.method_10084()) : !c.hasWreathAt(pos));
        }
        return false;
    }

    public static void clearHeldItem(class_1646 self) {
        self.method_5673(class_1304.field_6173, class_1799.field_8037);
        self.method_5946(class_1304.field_6173, 0.085f);
    }

    public static void displayAsHeldItem(class_1646 self, class_1799 stack) {
        self.method_5673(class_1304.field_6173, stack);
        self.method_5946(class_1304.field_6173, 0.0f);
    }
}

